package com.testor.module.contractor.manage.model.domain;

import java.time.LocalDateTime;
import java.util.Date;

import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;
import lombok.experimental.Accessors;
import lombok.experimental.SuperBuilder;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.baomidou.mybatisplus.annotation.TableName;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.tongtech.tfw.backend.common.models.supers.SuperModel;
import org.springframework.format.annotation.DateTimeFormat;


/**
 * 日常管理-每日工作计划-停/复工对象 t_contractor_daily_plan_stop_restart_work
 * 
 * @author testor-framework
 * @date 2024-11-29 10:10:46
 */
@Data
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
@TableName("t_contractor_daily_plan_stop_restart_work")
@ApiModel(value = "TContractorDailyPlanStopRestartWork对象" , description = "")
@SuperBuilder
@AllArgsConstructor
@NoArgsConstructor
public class TContractorDailyPlanStopRestartWork extends SuperModel
{
    private static final long serialVersionUID = 1L;
/**
 * 主键ID
 */
  @ApiModelProperty(value = "主键ID")

  @TableId("id")
  private String id;
/**
 * 日常工作计划id
 */
  @ApiModelProperty(value = "日常工作计划id")

  @TableField("plan_id")
  private String planId;
/**
 * 分类 0停工 1复工
 */
  @ApiModelProperty(value = "分类 0停工 1复工")

  @TableField("type")
  private String type;
/**
 * 流程实例ID
 */
  @ApiModelProperty(value = "流程实例ID")

  @TableField("process_id")
  private String processId;
/**
 * 流程状态
 */
  @ApiModelProperty(value = "流程状态")

  @TableField("process_status")
  private String processStatus;
/**
 * 申请人
 */
  @ApiModelProperty(value = "申请人")

  @TableField("applicant")
  private String applicant;
/**
 * 申请时间
 */
  @ApiModelProperty(value = "申请时间")

  @TableField("apply_time")
  @JsonFormat(timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
  @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private Date applyTime;
/**
 * 停/复工原因
 */
  @ApiModelProperty(value = "停/复工原因")

  @TableField("reason")
  private String reason;
/**
 * 附件，存文件id
 */
  @ApiModelProperty(value = "附件，存文件id")

  @TableField("attachment")
  private String attachment;

  public static final String ID ="id";
  public static final String PLAN_ID ="plan_id";
  public static final String TYPE ="type";
  public static final String PROCESS_ID ="process_id";
  public static final String PROCESS_STATUS ="process_status";
  public static final String APPLICANT ="applicant";
  public static final String APPLY_TIME ="apply_time";
  public static final String REASON ="reason";
  public static final String ATTACHMENT ="attachment";


}
