package com.testor.module.contractor.manage.model.domain;

import java.time.LocalDateTime;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;
import lombok.experimental.Accessors;
import lombok.experimental.SuperBuilder;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.baomidou.mybatisplus.annotation.TableName;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.tongtech.tfw.backend.common.models.supers.SuperModel;


/**
 * 开工准备-应急物资关系对象 t_contractor_preparation_emergency
 *
 * @author testor-framework
 * @date 2024-11-24 13:20:08
 */
@Data
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
@TableName("t_contractor_preparation_emergency")
@ApiModel(value = "TContractorPreparationEmergency对象", description = "")
@SuperBuilder
@AllArgsConstructor
@NoArgsConstructor
public class TContractorPreparationEmergency extends SuperModel {
    private static final long serialVersionUID = 1L;
    /**
     * 主键ID
     */
    @ApiModelProperty(value = "主键ID")

    @TableId("id")
    private String id;
    /**
     * 开工id
     */
    @ApiModelProperty(value = "开工id")

    @TableField("preparation_id")
    private String preparationId;
    /**
     * 应急物资id
     */
    @ApiModelProperty(value = "应急物资id")

    @TableField("emergency_id")
    private String emergencyId;
    /**
     * 业务id(标识是一条基本信息产生的关系)
     */
    @ApiModelProperty(value = "业务id(标识是一条基本信息产生的关系)")

    @TableField("biz_id")
    private String bizId;
    /**
     * 承包商id
     */
    @ApiModelProperty(value = "承包商id")

    @TableField("contractor_id")
    private String contractorId;
    /**
     * 项目id
     */
    @ApiModelProperty(value = "项目id")

    @TableField("proj_id")
    private String projId;

    public static final String ID = "id";
    public static final String PREPARATION_ID = "preparation_id";
    public static final String EMERGENCY_ID = "emergency_id";
    public static final String BIZ_ID = "biz_id";
    public static final String CONTRACTOR_ID = "contractor_id";
    public static final String PROJ_ID = "proj_id";


}
