package com.testor.module.contractor.manage.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.testor.module.contractor.ledger.model.domain.TContractorProtectiveEquipment;
import com.testor.module.contractor.ledger.model.domain.TContractorTools;
import com.testor.module.contractor.ledger.service.TContractorProtectiveEquipmentService;
import com.testor.module.contractor.ledger.service.TContractorToolsService;
import com.testor.module.contractor.manage.dao.TContractorAllowProtectiveDao;
import com.testor.module.contractor.manage.model.domain.TContractorAllowProtective;
import com.testor.module.contractor.manage.model.domain.TContractorAllowTools;
import com.testor.module.contractor.manage.model.dto.TContractorAllowProtectiveParam;
import com.testor.module.contractor.manage.model.vo.TContractorAllowProtectiveVo;
import com.testor.module.contractor.manage.service.TContractorAllowProtectiveService;
import com.tongtech.tfw.backend.common.biz.constants.BizConstants;
import com.tongtech.tfw.backend.core.helper.StringHelper;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;
import com.tongtech.tfw.backend.common.models.supers.SuperServiceImpl;
import org.springframework.beans.factory.annotation.Autowired;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;

/**
 * 准入信息-防护用品台账关联Service业务层处理
 * 
 * @author testor-framework
 * @date 2024-11-26 14:08:58
 */
@Service
public class TContractorAllowProtectiveServiceImpl extends SuperServiceImpl<TContractorAllowProtectiveDao, TContractorAllowProtective> implements TContractorAllowProtectiveService
{
    @Autowired(required = false)
    private TContractorAllowProtectiveDao tContractorAllowProtectiveDao;

    @Autowired
    private TContractorProtectiveEquipmentService tContractorProtectiveEquipmentService;

    @Override
    public List<String> getIdsByAllowId(String allowId) {
        List<TContractorAllowProtective> list = this.list(new LambdaQueryWrapper<TContractorAllowProtective>().eq(TContractorAllowProtective::getAllowId, allowId));
        if (list == null || list.isEmpty()) {
            return Collections.emptyList();
        }
        return list.stream().map(TContractorAllowProtective::getProtectiveId).collect(Collectors.toList());
    }

    @Override
    public List<TContractorAllowProtective> listAllEntity(TContractorAllowProtectiveParam param) {
        QueryWrapper<TContractorAllowProtective> queryWrapper = this.createQuery(param);
        List<TContractorAllowProtective> records= this.list(queryWrapper);
        for (TContractorAllowProtective record : records) {
            String id = record.getProtectiveId();
            TContractorProtectiveEquipment byId = tContractorProtectiveEquipmentService.getById(id);
            record.setTContractorProtectiveEquipment(byId);
            record.setId(id);
        }
        return records;

    }

    @Override
    public Page<TContractorAllowProtectiveVo> listEntity(TContractorAllowProtectiveParam param) {
        Long page =
                StringHelper.isEmpty(param.getPage()) ? BizConstants.PAGE : Long.valueOf(param.getPage());
        Long limit =
                StringHelper.isEmpty(param.getLimit()) ? BizConstants.LIMIT : Long.valueOf(param.getLimit());
        Page<TContractorAllowProtective> resultPage = new Page<>(page, limit);
        QueryWrapper<TContractorAllowProtective> queryWrapper = this.createQuery(param);
        Page<TContractorAllowProtective> pageList = this.page(resultPage, queryWrapper);
        List<TContractorAllowProtective> records = pageList.getRecords();

        List<TContractorAllowProtectiveVo> voList = new ArrayList<>();

        for (TContractorAllowProtective record : records) {
            String id = record.getProtectiveId();
            TContractorProtectiveEquipment byId = tContractorProtectiveEquipmentService.getById(id);
            record.setTContractorProtectiveEquipment(byId);
            TContractorAllowProtectiveVo vo = new TContractorAllowProtectiveVo();
            if (byId != null) {
                BeanUtils.copyProperties(byId, vo);
            }
            BeanUtils.copyProperties(record, vo);
            vo.setId(id);
            voList.add(vo);
        }
        Page<TContractorAllowProtectiveVo> voPage = new Page<>(page, limit);
        voPage.setRecords(voList);
        voPage.setTotal(pageList.getTotal());
        return voPage;
    }

    /* Private Methods */
    /**
     * 列表查询条件及查询参数
     */
    private QueryWrapper<TContractorAllowProtective> createQuery(TContractorAllowProtectiveParam queryParam){
        QueryWrapper<TContractorAllowProtective> queryWrapper=new QueryWrapper<>();
        if(StringHelper.isNotEmpty(queryParam.getAllowId())){
            queryWrapper.eq(TContractorAllowProtective.ALLOW_ID,queryParam.getAllowId());
        }
        if(StringHelper.isNotEmpty(queryParam.getProtectiveId())){
            queryWrapper.eq(TContractorAllowProtective.PROTECTIVE_ID,queryParam.getProtectiveId());
        }
        if(StringHelper.isNotEmpty(queryParam.getBizId())){
            queryWrapper.eq(TContractorAllowProtective.BIZ_ID,queryParam.getBizId());
        }
        if(StringHelper.isNotEmpty(queryParam.getContractorId())){
            queryWrapper.eq(TContractorAllowProtective.CONTRACTOR_ID,queryParam.getContractorId());
        }
        if(StringHelper.isNotEmpty(queryParam.getProjId())){
            queryWrapper.eq(TContractorAllowProtective.PROJ_ID,queryParam.getProjId());
        }
        if (StringHelper.isNotEmpty(queryParam.getStatus())) {
            queryWrapper.eq(TContractorAllowProtective.STATUS, queryParam.getStatus());
        } else {
            queryWrapper.ne(TContractorAllowProtective.STATUS, BizConstants.STATUS_DELETE);
        }
        if (StringHelper.isNotEmpty(queryParam.getOrderBy())){
            if(StringHelper.isNotEmpty(queryParam.getOrderType())
                    &&BizConstants.ASC.equals(queryParam.getOrderType())){
                queryWrapper.orderByAsc(queryParam.getOrderBy());
            }else{
                queryWrapper.orderByDesc(queryParam.getOrderBy());
            }
        }else{
            queryWrapper.orderByDesc(TContractorAllowProtective.UPDATE_DATE);
        }
        return queryWrapper;
    }

}
