package com.testor.module.contractor.manage.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.testor.module.contractor.manage.dao.TContractorDailyPlanChangeDao;
import com.testor.module.contractor.manage.model.domain.TContractorDailyPlanChange;
import com.testor.module.contractor.manage.service.TContractorDailyPlanChangeService;
import org.springframework.stereotype.Service;
import com.tongtech.tfw.backend.common.models.supers.SuperServiceImpl;
import org.springframework.beans.factory.annotation.Autowired;

/**
 * 日常管理-每日工作计划-变更Service业务层处理
 *
 * @author testor-framework
 * @date 2024-11-29 10:10:44
 */
@Service
public class TContractorDailyPlanChangeServiceImpl extends SuperServiceImpl<TContractorDailyPlanChangeDao,
        TContractorDailyPlanChange> implements TContractorDailyPlanChangeService {
    @Autowired(required = false)
    private TContractorDailyPlanChangeDao tContractorDailyPlanChangeDao;

    /**
     * 根据计划id获取最新的变更记录
     *
     * @param planId
     * @return
     */
    @Override
    public TContractorDailyPlanChange getByPlanId(String planId) {
        return this.getOne(new LambdaQueryWrapper<TContractorDailyPlanChange>().eq(TContractorDailyPlanChange::getPlanId, planId).orderByDesc(TContractorDailyPlanChange::getCreateDate).last("limit 1"));
    }
}
