package com.testor.module.duty.util;

import cn.hutool.json.JSONUtil;
import com.alibaba.excel.converters.Converter;
import com.alibaba.excel.enums.CellDataTypeEnum;
import com.alibaba.excel.metadata.CellData;
import com.alibaba.excel.metadata.GlobalConfiguration;
import com.alibaba.excel.metadata.property.ExcelContentProperty;
import com.testor.module.accident.model.excel.AccidentPersonnelVO;

import java.util.List;

/**
 * @title ListStringConverter
 * @description <TODO description class purpose>
 * @Author: qiao
 * @version:1.0.0
 * @create：4/19/23 10:18 AM
 */
public class ListStringConverter implements Converter<List> {
    @Override
    public Class supportJavaTypeKey() {
        return List.class;
    }

    @Override
    public CellDataTypeEnum supportExcelTypeKey() {
        return CellDataTypeEnum.STRING;
    }

    @Override
    public List convertToJavaData(CellData cellData, ExcelContentProperty excelContentProperty, GlobalConfiguration globalConfiguration) throws Exception {
        //从excel中读数据时被EasyExcel调用
        String stringValue = cellData.getStringValue();
        //用json转换工具将excel单元格中数据转换为java List<String>对象
        List<AccidentPersonnelVO> list = JSONUtil.toList(stringValue, AccidentPersonnelVO.class);
        return list;

    }

    @Override
    public CellData convertToExcelData(List list, ExcelContentProperty excelContentProperty, GlobalConfiguration globalConfiguration) throws Exception {
        //写excel文件时被EasyExcel调用
        //用json转换工具将List对象转换为json字符串
        String json = JSONUtil.toJsonStr(list);
        return new CellData(json);

    }
}
