package com.testor.module.emergency.controller;

import cn.hutool.core.bean.BeanUtil;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.testor.biz.sys.org.model.domain.SysOrg;
import com.testor.biz.sys.org.service.SysOrgService;
import com.testor.module.emergency.model.domain.TEmergencyRehearsal;
import com.testor.module.emergency.model.dto.EvaluateDTO;
import com.testor.module.emergency.model.dto.TEmergencyRehearsalDTO;
import com.testor.module.emergency.model.dto.TEmergencyRehearsalDelParam;
import com.testor.module.emergency.model.dto.TEmergencyRehearsalParam;
import com.testor.module.emergency.model.vo.EvaluateVO;
import com.testor.module.emergency.model.vo.TEmergencyRehearsalVO;
import com.testor.module.emergency.service.TEmergencyRehearsalService;
import com.tongtech.tfw.backend.common.biz.constants.BizConstants;
import com.tongtech.tfw.backend.common.biz.models.BaseResponse;
import com.tongtech.tfw.backend.common.biz.models.BaseResponseList;
import com.tongtech.tfw.backend.common.biz.models.BizGeneralResponse;
import com.tongtech.tfw.backend.common.context.ContextUtils;
import com.tongtech.tfw.backend.common.models.supers.SuperController;
import com.tongtech.tfw.backend.common.models.sys.UserInfo;
import com.tongtech.tfw.backend.core.helper.ObjectHelper;
import com.tongtech.tfw.backend.core.helper.StringHelper;
import com.tongtech.tfw.backend.core.helper.TypeHelper;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.*;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;


/**
 * 应急预案演练Controller
 *
 * @author testor-framework
 * @date 2022-12-02 15:50:38
 */
@RestController
@RequestMapping("/module/rehearsal")
@Api(value = "TEmergencyRehearsal", tags = "应急预案演练")
@Slf4j
public class TEmergencyRehearsalController extends SuperController
{
    @Autowired
    private TEmergencyRehearsalService tEmergencyRehearsalService;

	@Autowired
	private SysOrgService sysOrgService;

    /* Generated Method*/
	@ApiOperation(value = "新增 修改应急预案演练", notes = "Add TEmergencyRehearsal")
	@PostMapping(value = "/addAndUpdate")
	public BaseResponse<BizGeneralResponse>addAndUpdate(@RequestBody TEmergencyRehearsalDTO addRequest) {
        BaseResponse<BizGeneralResponse> baseResponse = new BaseResponse<>();
        boolean result= tEmergencyRehearsalService.addAndUpdate(addRequest);
        baseResponse.setData(
                BizGeneralResponse.builder().result(TypeHelper.castToString(result)).build());
        return baseResponse;
	}

	@ApiOperation(value = "获取 应急预案演练 ", notes = "Get TEmergencyRehearsal By Id")
	@GetMapping(value = "/get")
	public BaseResponse<TEmergencyRehearsalVO> getById(String id){
		BaseResponse<TEmergencyRehearsalVO> baseResponse=new BaseResponse<>();
		if(StringHelper.isNotEmpty(id)){
			// TODO 按需求添加业务异常判断
            TEmergencyRehearsal data= tEmergencyRehearsalService.getById(id);
			List list = JSONObject.parseArray(data.getSimulationEventType(), String.class);
			TEmergencyRehearsalVO tEmergencyRehearsalVO = BeanUtil.copyProperties(data, TEmergencyRehearsalVO.class);
			tEmergencyRehearsalVO.setSimulationEventTypeList(list);
			List list1 = JSONObject.parseArray(data.getSpecificObjectId(), String.class);
			tEmergencyRehearsalVO.setSpecificObjectIdList(list1);
			baseResponse.setData(tEmergencyRehearsalVO);
		}
		return baseResponse;
	}
//
//	@ApiOperation(value = "修改 应急预案演练 ", notes = "Update TEmergencyRehearsal By Id")
//	@PutMapping(value = "/update")
//	public BaseResponse<BizGeneralResponse> updateEntity(@RequestBody TEmergencyRehearsal updateRequest){
//		BaseResponse<BizGeneralResponse> baseResponse=new BaseResponse<>();
//		if(ObjectHelper.isNotEmpty(updateRequest)&&StringHelper.isNotEmpty(updateRequest.getId())){
//			// TODO 按需求添加数据去重，特殊值设定，业务异常
//            TEmergencyRehearsal data=BeanHelper.beanToBean(updateRequest, TEmergencyRehearsal.class);
//			boolean result= tEmergencyRehearsalService.updateById(data);
//			baseResponse.setData(
//					BizGeneralResponse.builder().result(TypeHelper.castToString(result)).build());
//		}
//		return baseResponse;
//	}
//
	@ApiOperation(value = "删除 应急预案演练 ", notes = "delete TEmergencyRehearsal By Id")
	@PutMapping(value = "/delete")
	public BaseResponse<BizGeneralResponse> deleteEntity(@RequestBody TEmergencyRehearsalDelParam deleteRequest){
		BaseResponse<BizGeneralResponse> baseResponse=new BaseResponse<>();
		if(ObjectHelper.isNotEmpty(deleteRequest)&&StringHelper.isNotEmpty(deleteRequest.getId())){
			// TODO 按需求添加数据去重，特殊值设定，业务异常
            TEmergencyRehearsal data= new TEmergencyRehearsal();
			data.setId(deleteRequest.getId());
			data.setStatus(BizConstants.STATUS_DELETE);
			boolean result= tEmergencyRehearsalService.updateById(data);
			baseResponse.setData(
					BizGeneralResponse.builder().result(TypeHelper.castToString(result)).build());
		}
		return baseResponse;
	}
	@ApiOperation(value = "新增评价", notes = "")
	@PostMapping(value = "/addAndUpdateEvaluate")
	public BaseResponse<BizGeneralResponse> addEvaluate(@RequestBody EvaluateDTO evaluateDTO){
		BaseResponse<BizGeneralResponse> baseResponse = new BaseResponse<>();
		boolean result= tEmergencyRehearsalService.addEvaluate(evaluateDTO);
		baseResponse.setData(
				BizGeneralResponse.builder().result(TypeHelper.castToString(result)).build());
		return baseResponse;
	}

	@ApiOperation(value = "获取评价", notes = "")
	@GetMapping(value = "/getEvaluate")
	public BaseResponse<EvaluateVO> getEvaluate(String id){
		BaseResponse<EvaluateVO> baseResponse=new BaseResponse<>();
		if(StringHelper.isNotEmpty(id)){
			// TODO 按需求添加业务异常判断
			EvaluateVO data= tEmergencyRehearsalService.getEvaluate(id);

			baseResponse.setData(data);
		}
		return baseResponse;
	}
//
//	@ApiOperation(value = "批量删除应急预案演练", notes = "delete TEmergencyRehearsal by batch Id")
//	@PutMapping(value = "/batch_delete")
//	public BaseResponse<BizGeneralResponse> deleteEntityBatch(
//			@RequestBody TEmergencyRehearsalDelParam deleteRequest) {
//		BaseResponse<BizGeneralResponse> baseResponse = new BaseResponse<>();
//		if (ObjectHelper.isNotEmpty(deleteRequest) && (!deleteRequest.getIds().isEmpty())) {
//            /* 批量删除 */
//			List<TEmergencyRehearsal> tEmergencyRehearsalList = new ArrayList<>();
//            for(String id: deleteRequest.getIds()){
//                TEmergencyRehearsal data= new TEmergencyRehearsal();
//				data.setId(id);
//				data.setStatus(BizConstants.STATUS_DELETE);
//                tEmergencyRehearsalList.add(data);
//			}
//			boolean result = tEmergencyRehearsalService.updateBatchById(tEmergencyRehearsalList);
//			baseResponse.setData(
//					BizGeneralResponse.builder().result(TypeHelper.castToString(result)).build());
//		}
//		return baseResponse;
//	}
//
	@ApiOperation(value = "获取 应急预案演练 分页列表", notes = "List TEmergencyRehearsal with page")
	@PostMapping(value = "/list")
	public  BaseResponse<BaseResponseList<TEmergencyRehearsalVO>>listEntity(@RequestBody TEmergencyRehearsalParam param){
		BaseResponse<BaseResponseList<TEmergencyRehearsalVO>>baseResponse=new BaseResponse<>();
		Long page=
				StringHelper.isEmpty(param.getPage())?BizConstants.PAGE:Long.valueOf(param.getPage());
		Long limit=
				StringHelper.isEmpty(param.getLimit())?BizConstants.LIMIT:Long.valueOf(param.getLimit());
		Page<TEmergencyRehearsalVO> resultPage=new Page<>(page,limit);
		// TODO 根据需求修改查询条件及查询参数
		if (CollectionUtils.isEmpty(param.getOrgIdList())) {
			param.setOrgIdList(new ArrayList<>());
			UserInfo loginUser = ContextUtils.getLoginUser();
			param.getOrgIdList().add(loginUser.getOrgId());
			List<SysOrg> childrenById = sysOrgService.getChildrenById(loginUser.getOrgId());

			if (CollectionUtils.isEmpty(childrenById)) {
				List<String> collect = childrenById.stream().map(SysOrg::getOrgId).collect(Collectors.toList());
				param.getOrgIdList().addAll(collect);
			}
		}

		Page<TEmergencyRehearsalVO> resultList= tEmergencyRehearsalService.listPage(resultPage,param);
		BaseResponseList<TEmergencyRehearsalVO> baseResponseList=new BaseResponseList<>();
		baseResponseList.setData(resultList.getRecords());
		baseResponseList.setTotal(resultList.getTotal());
		baseResponse.setData(baseResponseList);
		return baseResponse;
	}
//
//	@ApiOperation(value = "获取 应急预案演练 列表", notes = "List TEmergencyRehearsal all")
//	@GetMapping(value = "/datas")
//	public  BaseResponse<BaseResponseList<TEmergencyRehearsal>>listAllEntity(TEmergencyRehearsalParam param){
//		BaseResponse<BaseResponseList<TEmergencyRehearsal>>baseResponse=new BaseResponse<>();
//		// TODO 根据需求修改查询条件及查询参数
//		QueryWrapper<TEmergencyRehearsal> queryWrapper=this.createQuery(param);
//		List<TEmergencyRehearsal> resultList=tEmergencyRehearsalService.list(queryWrapper);
//		BaseResponseList<TEmergencyRehearsal> baseResponseList=new BaseResponseList<>();
//		baseResponseList.setData(resultList);
//		baseResponseList.setTotal(resultList.size());
//		baseResponse.setData(baseResponseList);
//		return baseResponse;
//	}

}
