package com.testor.module.emergency.model.domain;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.tongtech.tfw.backend.common.models.supers.SuperModel;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;
import lombok.experimental.Accessors;
import lombok.experimental.SuperBuilder;


/**
 * 应急救援组织机构对象 t_emergency_working_group
 *
 * @author testor-framework
 * @date 2022-11-17 11:51:40
 */
@Data
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
@TableName("t_emergency_working_group")
@ApiModel(value = "TEmergencyWorkingGroup对象", description = "")
@SuperBuilder
@AllArgsConstructor
@NoArgsConstructor
public class TEmergencyWorkingGroup extends SuperModel {
    private static final long serialVersionUID = 1L;
    /**
     * id
     */
    @ApiModelProperty(value = "id")

    @TableId("id")
    private String id;
    /**
     * 工作组对应的字典id
     */
    @ApiModelProperty(value = "工作组对应的字典id")

    @TableField("group_id")
    private String groupId;
    /**
     * 工作组的key
     */
    @ApiModelProperty(value = "工作组的key")

    @TableField("group_key")
    private String groupKey;
    /**
     * 工作小组名
     */
    @ApiModelProperty(value = "工作小组名")

    @TableField("name")
    private String name;
    /**
     * 职责
     */
    @ApiModelProperty(value = "职责")
    @TableField("responsibility")
    private String responsibility;

    /**
     * 组织机构id
     */
    @ApiModelProperty(value = "组织机构id")

    @TableField("org_id")
    private String orgId;

    public static final String ID = "id";
    public static final String GROUP_ID = "group_id";
    public static final String GROUP_KEY = "group_key";
    public static final String NAME = "name";
    public static final String RESPONSIBILITY = "responsibility";
    public static final String ORG_ID = "org_id";


}
