package com.testor.module.emergency.service;


import com.baomidou.mybatisplus.core.metadata.IPage;
import com.testor.module.emergency.model.domain.TEmergencyWorkingGroup;
import com.testor.module.emergency.model.dto.TEmergencyWorkingGroupDTO;
import com.testor.module.emergency.model.dto.TEmergencyWorkingGroupParam;
import com.testor.module.emergency.model.dto.TEmergencyWorkingGroupUpdateAddDel;
import com.testor.module.emergency.model.vo.TEmergencyWorkingUserVO;
import com.tongtech.tfw.backend.common.exception.BusinessException;
import com.tongtech.tfw.backend.common.models.supers.SuperService;

import java.util.List;
import java.util.Map;

/**
 * 应急救援组织机构Service接口
 *
 * @author testor-framework
 * @date 2022-11-17 11:51:40
 */
public interface TEmergencyWorkingGroupService extends SuperService<TEmergencyWorkingGroup> {

    /**
     * 更新添加删除
     *
     * @param tEmergencyWorkingGroupUpdateAddDel t应急工作小组名单
     * @return boolean
     */
    boolean updateAddDel(TEmergencyWorkingGroupUpdateAddDel tEmergencyWorkingGroupUpdateAddDel) throws BusinessException;

    /**
     * 获取工作组列表
     *
     * @param id id
     * @return {@link Map}
     */
    List<TEmergencyWorkingGroupDTO> getWorkingGroupList(String id);

    /**
     * 职责查看
     *
     * @param tEmergencyWorkingGroupParam
     * @return {@link IPage}
     */
    IPage getResponsibilityList(TEmergencyWorkingGroupParam tEmergencyWorkingGroupParam);


    List<TEmergencyWorkingUserVO> getWorkingGroupListAndUser(String id);
}
