package com.testor.module.environment.model.dto;

import com.testor.module.environment.model.domain.TEnvironmentMonthly;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.util.List;

/**
 * 节能环保月报 删除参数对象
 *
 * @author testor-framework
 * @date 2022-10-25 15:29:35
 */

@Data
@ApiModel(value = "TEnvironmentMonthly 列表查询参数对象")
@EqualsAndHashCode(callSuper = true)
public class TEnvironmentMonthlyParam extends TEnvironmentMonthly {
	private static final long serialVersionUID = 1L;
	@ApiModelProperty(value = "每页数量")
	private String limit;

	@ApiModelProperty(value = "当前页数")
	private String page;

	@ApiModelProperty(value = "排序字段")
	private String orderBy;

	@ApiModelProperty(value = "排序方式")
	private String orderType;
	@ApiModelProperty(value = "开始日期")
	private String startDate;

	@ApiModelProperty(value = "结束日期")
	private String endDate;

	private List<String> companyIds;
}
