package com.testor.module.fives.controller;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.testor.biz.sys.dict.data.model.dto.SysDictDataListResponse;
import com.testor.biz.sys.user.service.SysUserService;
import com.testor.module.fives.model.domain.TFivesStandard;
import com.testor.module.fives.model.domain.TFivesSubOption;
import com.testor.module.fives.model.dto.TFivesSubOptionParam;
import com.testor.module.fives.model.vo.TFivesStandardCheckListVO;
import com.testor.module.fives.service.TFivesStandardService;
import com.testor.module.fives.service.TFivesSubOptionService;
import com.tongtech.tfw.backend.common.biz.constants.BizConstants;
import com.tongtech.tfw.backend.common.biz.models.BaseResponse;
import com.tongtech.tfw.backend.common.biz.models.BaseResponseList;
import com.tongtech.tfw.backend.common.models.supers.SuperController;
import com.tongtech.tfw.backend.core.helper.ObjectHelper;
import com.tongtech.tfw.backend.core.helper.StringHelper;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * 5s内容分项Controller
 *
 * @author testor-framework
 * @date 2022-07-11 14:07:47
 */
@RestController
@RequestMapping("/module/fives/sub/option")
@Api(value = "TFivesSubOption", tags = "5s内容分项")
@Slf4j
public class TFivesSubOptionController extends SuperController {
    @Autowired
    private TFivesSubOptionService tFivesSubOptionService;

    @Autowired
    private TFivesStandardService tFivesStandardService;

    @Autowired
    private SysUserService sysUserService;

    /*@ApiOperation(value = "新增 5s内容分项", notes = "Add TFivesSubOption")
    @PostMapping(value = "/add")
    public BaseResponse<TFivesSubOption> addEntity(@RequestBody TFivesSubOption addRequest) {
        BaseResponse<TFivesSubOption> baseResponse = new BaseResponse<>();
        if (ObjectHelper.isNotEmpty(addRequest)) {
            // TODO 按需求添加数据去重，特殊值设定，业务异常
            String id = IdHelper.getId32bit();
            TFivesSubOption data = BeanHelper.beanToBean(addRequest, TFivesSubOption.class);
            data.setId(id);
            boolean result = tFivesSubOptionService.save(data);
            if (result) {
                TFivesSubOption newEntity = new TFivesSubOption();
                newEntity.setId(id);
                baseResponse.setData(newEntity);
            }
        }
        return baseResponse;
    }*/

    /*@ApiOperation(value = "获取 5s内容分项 ", notes = "Get TFivesSubOption By Id")
    @GetMapping(value = "/get")
    public BaseResponse<TFivesSubOption> getById(String id) {
        BaseResponse<TFivesSubOption> baseResponse = new BaseResponse<>();
        if (StringHelper.isNotEmpty(id)) {
            // TODO 按需求添加业务异常判断
            TFivesSubOption data = tFivesSubOptionService.getById(id);
            baseResponse.setData(data);
        }
        return baseResponse;
    }*/

   /* @ApiOperation(value = "修改 5s内容分项 ", notes = "Update TFivesSubOption By Id")
    @PutMapping(value = "/update")
    public BaseResponse<BizGeneralResponse> updateEntity(@RequestBody TFivesSubOption updateRequest) {
        BaseResponse<BizGeneralResponse> baseResponse = new BaseResponse<>();
        if (ObjectHelper.isNotEmpty(updateRequest) && StringHelper.isNotEmpty(updateRequest.getId())) {
            // TODO 按需求添加数据去重，特殊值设定，业务异常
            TFivesSubOption data = BeanHelper.beanToBean(updateRequest, TFivesSubOption.class);
            boolean result = tFivesSubOptionService.updateById(data);
            baseResponse.setData(
                    BizGeneralResponse.builder().result(TypeHelper.castToString(result)).build());
        }
        return baseResponse;
    }*/

    /*@ApiOperation(value = "删除 5s内容分项 ", notes = "delete TFivesSubOption By Id")
    @PutMapping(value = "/delete")
    public BaseResponse<BizGeneralResponse> deleteEntity(@RequestBody TFivesSubOptionDelParam deleteRequest) {
        BaseResponse<BizGeneralResponse> baseResponse = new BaseResponse<>();
        if (ObjectHelper.isNotEmpty(deleteRequest) && StringHelper.isNotEmpty(deleteRequest.getId())) {
            // TODO 按需求添加数据去重，特殊值设定，业务异常
            TFivesSubOption data = new TFivesSubOption();
            data.setId(deleteRequest.getId());
            data.setStatus(BizConstants.STATUS_DELETE);
            boolean result = tFivesSubOptionService.updateById(data);
            baseResponse.setData(
                    BizGeneralResponse.builder().result(TypeHelper.castToString(result)).build());
        }
        return baseResponse;
    }*/

    /*@ApiOperation(value = "批量删除5s内容分项", notes = "delete TFivesSubOption by batch Id")
    @PutMapping(value = "/batch_delete")
    public BaseResponse<BizGeneralResponse> deleteEntityBatch(
            @RequestBody TFivesSubOptionDelParam deleteRequest) {
        BaseResponse<BizGeneralResponse> baseResponse = new BaseResponse<>();
        if (ObjectHelper.isNotEmpty(deleteRequest) && (!deleteRequest.getIds().isEmpty())) {
            *//* 批量删除 *//*
            List<TFivesSubOption> tFivesSubOptionList = new ArrayList<>();
            for (String id : deleteRequest.getIds()) {
                TFivesSubOption data = new TFivesSubOption();
                data.setId(id);
                data.setStatus(BizConstants.STATUS_DELETE);
                tFivesSubOptionList.add(data);
            }
            boolean result = tFivesSubOptionService.updateBatchById(tFivesSubOptionList);
            baseResponse.setData(
                    BizGeneralResponse.builder().result(TypeHelper.castToString(result)).build());
        }
        return baseResponse;
    }*/

    @ApiOperation(value = "获取 5s标准查看 分页列表", notes = "List TFivesSubOption with page")
    @GetMapping(value = "/standardCheck")
    public BaseResponse<TFivesStandardCheckListVO> listEntity(TFivesSubOptionParam param) {
        BaseResponse<TFivesStandardCheckListVO> baseResponse = new BaseResponse<>();

        TFivesStandardCheckListVO tFivesStandardCheckListVO = new TFivesStandardCheckListVO();
        TFivesStandard data = tFivesStandardService.getById(param.getId());

        Map<String, List<SysDictDataListResponse>> map = new HashMap<>(16);
        setDate(data, map);

        tFivesStandardCheckListVO.setSubOption(data.getSubOption());
        tFivesStandardCheckListVO.setStandardType(data.getStandardType());
        tFivesStandardCheckListVO.setChild(data.getChild());

        IPage<TFivesSubOption> tFivesSubOptionIPage = tFivesSubOptionService.standardCheck(param);
        String standardCheckSum = tFivesSubOptionService.standardCheckSum(param);

        BaseResponseList<TFivesSubOption> baseResponseList = new BaseResponseList<>();
        List<TFivesSubOption> records = tFivesSubOptionIPage.getRecords();
        records.stream().forEach(item->{
            item.setCreateBy(sysUserService.getById(item.getCreateBy()).getUserName());
            item.setUpdateBy(sysUserService.getById(item.getUpdateBy()).getUserName());
        });
        baseResponseList.setData(records);
        baseResponseList.setTotal(tFivesSubOptionIPage.getTotal());
        tFivesStandardCheckListVO.setListTotalScore(standardCheckSum);
        tFivesStandardCheckListVO.setBaseResponseList(baseResponseList);
        baseResponse.setData(tFivesStandardCheckListVO);
        return baseResponse;
    }

    private void setDate(TFivesStandard data, Map<String, List<SysDictDataListResponse>> map) {
        // 一级
        String standardType = data.getStandardType();
        List<SysDictDataListResponse> levelOne = map.get(standardType);
        data.setStandardType(tFivesStandardService.getDictValue(levelOne, standardType, map, "5S_ACCEPTANCE_STANDARD_TYPE"));

        // 二级
        String subOption = data.getSubOption();
        List<SysDictDataListResponse> levelTow = map.get(subOption);
        data.setSubOption(tFivesStandardService.getDictValue(levelTow, subOption, map, standardType));

        // 三级
        String child = data.getChild();
        List<SysDictDataListResponse> levelThree = map.get(child);
        data.setChild(tFivesStandardService.getDictValue(levelThree, child, map, subOption));
    }

    @ApiOperation(value = "获取 5s标准查看 检索框-主要内容下拉使用")
    @GetMapping(value = "/getMainContent")
    public BaseResponse<List<String>> getMainContent(String id) {
        BaseResponse<List<String>> baseResponse = new BaseResponse<>();
        List<String> mainContent = tFivesSubOptionService.getMainContent(id);
        baseResponse.setData(mainContent);
        return baseResponse;
    }



    /*@ApiOperation(value = "获取 5s内容分项 列表", notes = "List TFivesSubOption all")
    @GetMapping(value = "/datas")
    public BaseResponse<BaseResponseList<TFivesSubOption>> listAllEntity(TFivesSubOptionParam param) {
        BaseResponse<BaseResponseList<TFivesSubOption>> baseResponse = new BaseResponse<>();
        // TODO 根据需求修改查询条件及查询参数
        QueryWrapper<TFivesSubOption> queryWrapper = this.createQuery(param);
        List<TFivesSubOption> resultList = tFivesSubOptionService.list(queryWrapper);
        BaseResponseList<TFivesSubOption> baseResponseList = new BaseResponseList<>();
        baseResponseList.setData(resultList);
        baseResponseList.setTotal(resultList.size());
        baseResponse.setData(baseResponseList);
        return baseResponse;
    }*/


    /**
     * 列表查询条件及查询参数
     */
    private QueryWrapper<TFivesSubOption> createQuery(TFivesSubOptionParam queryParam) {
        QueryWrapper<TFivesSubOption> queryWrapper = new QueryWrapper<>();
        if (StringHelper.isNotEmpty(queryParam.getRefId())) {
            queryWrapper.eq(TFivesSubOption.REF_ID, queryParam.getRefId());
        }
        if (StringHelper.isNotEmpty(queryParam.getParentId())) {
            queryWrapper.eq(TFivesSubOption.PARENT_ID, queryParam.getParentId());
        }
        if (StringHelper.isNotEmpty(queryParam.getTenantId())) {
            queryWrapper.eq(TFivesSubOption.TENANT_ID, queryParam.getTenantId());
        }
        if (StringHelper.isNotEmpty(queryParam.getProcessId())) {
            queryWrapper.eq(TFivesSubOption.PROCESS_ID, queryParam.getProcessId());
        }
        if (StringHelper.isNotEmpty(queryParam.getProcessStatus())) {
            queryWrapper.eq(TFivesSubOption.PROCESS_STATUS, queryParam.getProcessStatus());
        }
        if (StringHelper.isNotEmpty(queryParam.getOrgId())) {
            queryWrapper.eq(TFivesSubOption.ORG_ID, queryParam.getOrgId());
        }
        if (StringHelper.isNotEmpty(queryParam.getName())) {
            queryWrapper.like(TFivesSubOption.NAME, queryParam.getName());
        }
        if (StringHelper.isNotEmpty(queryParam.getContent())) {
            queryWrapper.eq(TFivesSubOption.CONTENT, queryParam.getContent());
        }
        if (StringHelper.isNotEmpty(queryParam.getDetailRules())) {
            queryWrapper.eq(TFivesSubOption.DETAIL_RULES, queryParam.getDetailRules());
        }
        if (StringHelper.isNotEmpty(queryParam.getContentType())) {
            queryWrapper.eq(TFivesSubOption.CONTENT_TYPE, queryParam.getContentType());
        }
        if (ObjectHelper.isNotEmpty(queryParam.getScore())) {
            queryWrapper.eq(TFivesSubOption.SCORE, queryParam.getScore());
        }
        if (StringHelper.isNotEmpty(queryParam.getSubId())) {
            queryWrapper.eq(TFivesSubOption.SUB_ID, queryParam.getSubId());
        }
        if (StringHelper.isNotEmpty(queryParam.getStatus())) {
            queryWrapper.eq(TFivesSubOption.STATUS, queryParam.getStatus());
        } else {
            queryWrapper.ne(TFivesSubOption.STATUS, BizConstants.STATUS_DELETE);
        }
        if (StringHelper.isNotEmpty(queryParam.getOrderBy())) {
            if (StringHelper.isNotEmpty(queryParam.getOrderType())
                    && BizConstants.ASC.equals(queryParam.getOrderType())) {
                queryWrapper.orderByAsc(queryParam.getOrderBy());
            } else {
                queryWrapper.orderByDesc(queryParam.getOrderBy());
            }
        } else {
            queryWrapper.orderByDesc(TFivesSubOption.UPDATE_DATE);
        }
        return queryWrapper;
    }
}
