package com.testor.module.fives.model.domain;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.tongtech.tfw.backend.common.models.supers.SuperModel;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;
import lombok.experimental.Accessors;
import lombok.experimental.SuperBuilder;

import java.math.BigDecimal;


/**
 * 5s内容分项对象 t_fives_sub_option
 *
 * @author testor-framework
 * @date 2022-07-11 14:07:47
 */
@Data
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
@TableName("t_fives_sub_option")
@ApiModel(value = "TFivesSubOption对象", description = "")
@SuperBuilder
@AllArgsConstructor
@NoArgsConstructor
public class TFivesSubOption extends SuperModel {
    private static final long serialVersionUID = 1L;
    /**
     * 主键ID
     */
    @ApiModelProperty(value = "主键ID")

    @TableId("id")
    private String id;
    /**
     * 附件上传
     */
    @ApiModelProperty(value = "附件上传")

    @TableField("ref_id")
    private String refId;
    /**
     * 父级ID
     */
    @ApiModelProperty(value = "父级ID")

    @TableField("parent_id")
    private String parentId;
    /**
     * 租户id
     */
    @ApiModelProperty(value = "租户id")

    @TableField("tenant_id")
    private String tenantId;
    /**
     * 流程实例ID
     */
    @ApiModelProperty(value = "流程实例ID")

    @TableField("process_id")
    private String processId;
    /**
     * 流程状态
     */
    @ApiModelProperty(value = "流程状态")

    @TableField("process_status")
    private String processStatus;
    /**
     * 所属组织机构id
     */
    @ApiModelProperty(value = "所属组织机构id")

    @TableField("org_id")
    private String orgId;
    /**
     * 主要内容名称
     */
    @ApiModelProperty(value = "主要内容名称")

    @TableField("name")
    private String name;
    /**
     * 评分要点内容
     */
    @ApiModelProperty(value = "评分要点内容")

    @TableField("content")
    private String content;
    /**
     * 评分细则
     */
    @ApiModelProperty(value = "评分细则")

    @TableField("detail_rules")
    private String detailRules;
    /**
     * 内容类型（1-大类；2-小类）
     */
    @ApiModelProperty(value = "内容类型（1-大类；2-小类）")

    @TableField("content_type")
    private String contentType;
    /**
     * 分值（类型为大类时，分值为总和；类型为小类时，分值是单项分值）
     */
    @ApiModelProperty(value = "分值（类型为大类时，分值为总和；类型为小类时，分值是单项分值）", example = "0")

    @TableField("score")
    private BigDecimal score;
    /**
     * 内容分项id，该值当类型为小类时有值
     */
    @ApiModelProperty(value = "内容分项id，该值当类型为小类时有值")

    @TableField("sub_id")
    private String subId;

    public static final String ID = "id";
    public static final String REF_ID = "ref_id";
    public static final String PARENT_ID = "parent_id";
    public static final String TENANT_ID = "tenant_id";
    public static final String PROCESS_ID = "process_id";
    public static final String PROCESS_STATUS = "process_status";
    public static final String ORG_ID = "org_id";
    public static final String NAME = "name";
    public static final String CONTENT = "content";
    public static final String DETAIL_RULES = "detail_rules";
    public static final String CONTENT_TYPE = "content_type";
    public static final String SCORE = "score";
    public static final String SUB_ID = "sub_id";


}
