package com.testor.module.fives.model.domain;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.tongtech.tfw.backend.common.models.supers.SuperModel;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;
import lombok.experimental.Accessors;
import lombok.experimental.SuperBuilder;

import java.math.BigDecimal;


/**
 * 5s工具运用对象 t_fives_tool_use
 *
 * @author testor-framework
 * @date 2022-07-21 15:56:55
 */
@Data
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
@TableName("t_fives_tool_use")
@ApiModel(value = "TFivesToolUse对象", description = "")
@SuperBuilder
@AllArgsConstructor
@NoArgsConstructor
public class TFivesToolUse extends SuperModel {
    private static final long serialVersionUID = 1L;
    /**
     * 主键ID
     */
    @ApiModelProperty(value = "主键ID")
    @TableId("id")
    private String id;
    /**
     * 附件上传
     */
    @ApiModelProperty(value = "附件上传")
    @TableField("ref_id")
    private String refId;
    /**
     * 父级ID
     */
    @ApiModelProperty(value = "父级ID")
    @TableField("parent_id")
    private String parentId;
    /**
     * 租户id
     */
    @ApiModelProperty(value = "租户id")
    @TableField("tenant_id")
    private String tenantId;
    /**
     * 流程实例ID
     */
    @ApiModelProperty(value = "流程实例ID")
    @TableField("process_id")
    private String processId;
    /**
     * 流程状态
     */
    @ApiModelProperty(value = "流程状态")
    @TableField("process_status")
    private String processStatus;
    /**
     * 所属组织机构id（粮库id）
     */
    @ApiModelProperty(value = "所属组织机构id（粮库id）")
    @TableField("grain_org_id")
    private String grainOrgId;
    /**
     * 工具类型（0-opl一点课；1-改善案例；2-焦点课题）
     */
    @ApiModelProperty(value = "工具类型（0-opl一点课；1-改善案例；2-焦点课题）")
    @TableField("use_type")
    private String useType;
    /**
     * 编号
     */
    @ApiModelProperty(value = "编号")
    @TableField("serial_number")
    private String serialNumber;

    /**
     * 评分
     */
    @ApiModelProperty(value = "评分")
    @TableField("score")
    private BigDecimal score;

    /**
     * 评分状态（7-未评；6-评价中；8-已评完）排序使用
     */
    @ApiModelProperty(value = "评分状态（7-未评；6-评价中；8-已评完）排序使用")
    @TableField("score_type")
    private String scoreType;

    /**
     * 所属组织机构id（区域公司id）
     */
    @ApiModelProperty(value = "所属组织机构id（区域公司id）")
    @TableField("area_org_id")
    private String areaOrgId;

    @ApiModelProperty(value = "机构id 创建人")
    @TableField("org_id")
    private String orgId;

    @ApiModelProperty(value = "热点数据所属企业")
    @TableField("host_post")
    private String hostPost;


    public static final String ID = "id";
    public static final String REF_ID = "ref_id";
    public static final String PARENT_ID = "parent_id";
    public static final String TENANT_ID = "tenant_id";
    public static final String PROCESS_ID = "process_id";
    public static final String PROCESS_STATUS = "process_status";
    public static final String ORG_ID = "org_id";
    public static final String USE_TYPE = "use_type";
    public static final String SERIAL_NUMBER = "serial_number";
    public static final String SCORE = "score";
    public static final String SCORE_TYPE = "score_type";
    public static final String HOST_POST = "host_post";


}
