package com.testor.module.fives.model.dto;

import com.tongtech.tfw.backend.common.models.supers.SuperModel;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.math.BigDecimal;
import java.util.List;


/**
 * 5s内容分项对象 t_fives_sub_option
 *
 * @author testor-framework
 * @date 2022-07-11 14:07:47
 */
@Data
@ApiModel(value = "TFivesSubOptionDTO对象", description = "")
public class TFivesSubOptionDTO extends SuperModel {
    private static final long serialVersionUID = 1L;

    /**
     * 主键ID
     */
    @ApiModelProperty(value = "主键ID")
    private String id;

    /**
     * 父级ID
     */
    @ApiModelProperty(value = "父级ID")
    private String parentId;


    /**
     * 所属组织机构id
     */
    @ApiModelProperty(value = "所属组织机构id")
    private String orgId;

    /**
     * 主要内容名称
     */
    @ApiModelProperty(value = "主要内容名称")
    private String name;

    /**
     * 评分要点内容
     */
    @ApiModelProperty(value = "评分要点内容")
    private String content;

    /**
     * 评分细则
     */
    @ApiModelProperty(value = "评分细则")
    private String detailRules;

    /**
     * 内容类型（1-大类；2-小类）
     */
    @ApiModelProperty(value = "内容类型（1-大类；2-小类）")
    private String contentType;

    /**
     * 分值（类型为大类时，分值为总和；类型为小类时，分值是单项分值）
     */
    @ApiModelProperty(value = "分值（类型为大类时，分值为总和；类型为小类时，分值是单项分值）", example = "0")
    private BigDecimal score;

    /**
     * 内容分项id，该值当类型为小类时有值
     */
    @ApiModelProperty(value = "内容分项id，该值当类型为小类时有值")
    private String subId;

    /**
     * 主要内用及评分项
     */
    @ApiModelProperty("主要内用及评分项 二级")
    private List<TFivesSubOptionDTO> levelTow;
}
