package com.testor.module.fives.model.vo;

import com.tongtech.tfw.backend.common.models.supers.SuperModel;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.math.BigDecimal;
import java.util.List;


/**
 * 5s标准验收管理对象 t_fives_standard
 *
 * @author testor-framework
 * @date 2022-07-11 14:00:17
 */
@Data
@ApiModel(value = "TFivesStandardVO对象", description = "")
public class TFivesStandardVO extends SuperModel {
    private static final long serialVersionUID = 1L;
    /**
     * 主键ID
     */
    @ApiModelProperty(value = "主键ID")
    private String id;

    /**
     * 所属组织机构id
     */
    @ApiModelProperty(value = "所属组织机构id")
    private String orgId;

    /**
     * 标准类型（字典key - FIVES_STANDARD_TYPE）
     */
    @ApiModelProperty(value = "标准类型（字典key - FIVES_STANDARD_TYPE）")
    private String standardType;

    /**
     * 标准名称
     */
    @ApiModelProperty(value = "标准名称")
    private String standardName;

    /**
     * 分项
     */
    @ApiModelProperty(value = "分项")
    private String subOption;

    /**
     * 子项
     */
    @ApiModelProperty(value = "子项")
    private String child;

    /**
     * 总分
     */
    @ApiModelProperty(value = "总分", example = "0")
    private BigDecimal totalScore;

    /**
     * 主要内用及评分项
     */
    @ApiModelProperty("主要内用及评分项 一级")
    private List<TFivesSubOptionVO> levelOne;

}
