package com.testor.module.fives.service.impl;

import cn.hutool.core.util.StrUtil;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.testor.biz.sys.org.model.domain.SysOrg;
import com.testor.biz.sys.org.service.SysOrgService;
import com.testor.module.fives.dao.TFivesToolFocusDao;
import com.testor.module.fives.model.domain.TFivesToolFocus;
import com.testor.module.fives.model.excel.TFivesToolFocusReport;
import com.testor.module.fives.service.TFivesToolFocusService;
import com.tongtech.tfw.backend.common.models.supers.SuperServiceImpl;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * 5s工具运用焦点课题Service业务层处理
 *
 * @author testor-framework
 * @date 2022-07-21 15:56:54
 */
@Service("tFivesToolFocusServiceImpl")
public class TFivesToolFocusServiceImpl extends SuperServiceImpl<TFivesToolFocusDao, TFivesToolFocus> implements TFivesToolFocusService {
    @Autowired(required = false)
    private TFivesToolFocusDao tFivesToolFocusDao;
    @Autowired
    private SysOrgService sysOrgService;

    @Override
    public List<TFivesToolFocusReport> exportFivesToolFocus(String dsName, String datasetName, Map<String, Object> parameters) {
        List<TFivesToolFocusReport> tFivesToolFocusReports = tFivesToolFocusDao.focusReport();
        Map<String,String> map=new HashMap<>(16);
        for (TFivesToolFocusReport focusReport : tFivesToolFocusReports) {
            // 总部
            String areaOrgId = focusReport.getAreaOrgId();
            // 粮库
            String grainOrgId = focusReport.getGrainOrgId();
            if(StrUtil.isNotEmpty(grainOrgId)){
                String grainOrgName = orgName(map, grainOrgId);
                focusReport.setGrainOrgId(grainOrgName);
            }

            String areaOrgName = orgName(map, areaOrgId);
            focusReport.setAreaOrgId(areaOrgName);
        }
        return tFivesToolFocusReports;
    }

    public String orgName(Map<String,String> map,String orgId){
        String orgName = map.get(orgId);
        if(StrUtil.isEmpty(orgName)){
            QueryWrapper<SysOrg> sysOrgQueryWrapper = new QueryWrapper<>();
            sysOrgQueryWrapper.eq("org_id", orgId);
            SysOrg sysOrg = sysOrgService.getOne(sysOrgQueryWrapper);

            orgName = sysOrg.getOrgName();

            map.put(orgId,orgName);
        }

        return orgName;
    }
}
