package com.testor.module.fives.service.impl;

import cn.hutool.core.util.StrUtil;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.testor.biz.sys.org.model.domain.SysOrg;
import com.testor.biz.sys.org.service.SysOrgService;
import com.testor.module.fives.dao.TFivesToolOplDao;
import com.testor.module.fives.model.domain.TFivesToolOpl;
import com.testor.module.fives.model.excel.TFivesToolOplReport;
import com.testor.module.fives.service.TFivesToolOplService;
import com.tongtech.tfw.backend.common.biz.models.BaseResponse;
import com.tongtech.tfw.backend.common.models.supers.SuperServiceImpl;
import com.tongtech.tfw.backend.core.helper.IdHelper;
import com.tongtech.tfw.backend.core.helper.ObjectHelper;
import com.tongtech.tfw.backend.core.helper.bean.BeanHelper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * 5s工具运用oplService业务层处理
 *
 * @author testor-framework
 * @date 2022-07-21 15:56:54
 */
@Service("tFivesToolOplServiceImpl")
public class TFivesToolOplServiceImpl extends SuperServiceImpl<TFivesToolOplDao, TFivesToolOpl> implements TFivesToolOplService {
    @Autowired(required = false)
    private TFivesToolOplDao tFivesToolOplDao;

    @Autowired
    private SysOrgService sysOrgService;

    @Override
    public BaseResponse<TFivesToolOpl> addOpl(TFivesToolOpl addRequest) {
        BaseResponse<TFivesToolOpl> baseResponse = new BaseResponse<>();
        if (ObjectHelper.isNotEmpty(addRequest)) {
            // TODO 按需求添加数据去重，特殊值设定，业务异常
            String id = IdHelper.getId32bit();
            TFivesToolOpl data = BeanHelper.beanToBean(addRequest, TFivesToolOpl.class);
            data.setId(id);
            boolean result = save(data);
            if (result) {
                TFivesToolOpl newEntity = new TFivesToolOpl();
                newEntity.setId(id);
                baseResponse.setData(newEntity);
            }
        }
        return baseResponse;
    }

    @Override
    public List<TFivesToolOplReport> exportFivesToolOpl(String dsName, String datasetName, Map<String, Object> parameters) {

        List<TFivesToolOplReport> tFivesToolOplReports = tFivesToolOplDao.oplReport();
        Map<String,String> map=new HashMap<>(16);
        for (TFivesToolOplReport toolOplReport : tFivesToolOplReports) {
            // 总部
            String areaOrgId = toolOplReport.getAreaOrgId();
            // 粮库
            String grainOrgId = toolOplReport.getGrainOrgId();
            if(StrUtil.isNotEmpty(grainOrgId)){
                String grainOrgName = orgName(map, grainOrgId);
                toolOplReport.setGrainOrgId(grainOrgName);
            }

            String areaOrgName = orgName(map, areaOrgId);
            toolOplReport.setAreaOrgId(areaOrgName);
        }
        return tFivesToolOplReports;
    }

    public String orgName(Map<String,String> map,String orgId){
        String orgName = map.get(orgId);
        if(StrUtil.isEmpty(orgName)){
            QueryWrapper<SysOrg> sysOrgQueryWrapper = new QueryWrapper<>();
            sysOrgQueryWrapper.eq("org_id", orgId);
            SysOrg sysOrg = sysOrgService.getOne(sysOrgQueryWrapper);

            orgName = sysOrg.getOrgName();

            map.put(orgId,orgName);
        }

        return orgName;
    }
}
