package com.testor.module.hazard.controller;

import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;

import com.testor.module.hazard.model.dto.THazardConditionConfirmationDTO;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import lombok.extern.slf4j.Slf4j;
import com.tongtech.tfw.backend.core.helper.StringHelper;
import com.tongtech.tfw.backend.core.helper.ObjectHelper;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RestController;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.tongtech.tfw.backend.common.biz.constants.BizConstants;
import com.tongtech.tfw.backend.common.biz.models.BaseResponse;
import com.tongtech.tfw.backend.common.biz.models.BaseResponse;
import com.tongtech.tfw.backend.common.biz.models.BaseResponseList;
import com.tongtech.tfw.backend.common.biz.models.BizGeneralResponse;
import com.tongtech.tfw.backend.common.models.exceptions.ApiException;
import com.tongtech.tfw.backend.common.models.supers.SuperController;
import com.tongtech.tfw.backend.core.helper.IdHelper;
import com.tongtech.tfw.backend.core.helper.TypeHelper;
import com.tongtech.tfw.backend.core.helper.bean.BeanHelper;

import com.testor.module.hazard.model.domain.THazardConditionConfirmation;
import com.testor.module.hazard.model.dto.THazardConditionConfirmationParam;
import com.testor.module.hazard.model.dto.THazardConditionConfirmationDelParam;
import com.testor.module.hazard.service.THazardConditionConfirmationService;

/**
 * 安全条件确认Controller
 *
 * @author testor-framework
 * @date 2024-12-24 21:53:21
 */
@RestController
@RequestMapping("/hazard/confirmation")
@Api(value = "THazardConditionConfirmation", tags = "安全条件确认")
@Slf4j
public class THazardConditionConfirmationController extends SuperController
{
    @Autowired
    private THazardConditionConfirmationService tHazardConditionConfirmationService;

    /* Generated Method*/
	@ApiOperation(value = "新增 安全条件确认", notes = "Add THazardConditionConfirmation")
	@PostMapping(value = "/saveOrUpdate")
	public BaseResponse<THazardConditionConfirmation>saveOrUpdateEntity(@RequestBody THazardConditionConfirmationDTO addRequest) {
		BaseResponse<THazardConditionConfirmation> baseResponse=new BaseResponse<>();
		if(ObjectHelper.isNotEmpty(addRequest)){
			THazardConditionConfirmation data = tHazardConditionConfirmationService.saveOrUpdateEntity(addRequest);
			baseResponse.setData(data);
		}
		return baseResponse;
	}

	@ApiOperation(value = "获取 安全条件确认 ", notes = "Get THazardConditionConfirmation By Id")
	@GetMapping(value = "/get")
	public BaseResponse<THazardConditionConfirmationDTO> getById(String planId,String workTypeId,String batch){
		BaseResponse<THazardConditionConfirmationDTO> baseResponse=new BaseResponse<>();
		// TODO 按需求添加业务异常判断
		THazardConditionConfirmationDTO data= tHazardConditionConfirmationService.getDetailsById(planId,workTypeId,batch);
		baseResponse.setData(data);
		return baseResponse;
	}

	@ApiOperation(value = "发送跨天-测试使用", notes = "发送通知-测试使用")
	@GetMapping(value = "/hazardousWorkDailyCheck")
	public BaseResponse<BizGeneralResponse> hazardousWorkDailyCheck(String todayStr){
		BaseResponse<BizGeneralResponse> baseResponse=new BaseResponse<>();
		tHazardConditionConfirmationService.hazardousWorkDailyCheck(todayStr);
		return baseResponse;
	}

	@ApiOperation(value = "修改 安全条件确认 ", notes = "Update THazardConditionConfirmation By Id")
	@PutMapping(value = "/update")
	public BaseResponse<BizGeneralResponse> updateEntity(@RequestBody THazardConditionConfirmation updateRequest){
		BaseResponse<BizGeneralResponse> baseResponse=new BaseResponse<>();
		if(ObjectHelper.isNotEmpty(updateRequest)&&StringHelper.isNotEmpty(updateRequest.getId())){
			// TODO 按需求添加数据去重，特殊值设定，业务异常
            THazardConditionConfirmation data=BeanHelper.beanToBean(updateRequest, THazardConditionConfirmation.class);
			boolean result= tHazardConditionConfirmationService.updateById(data);
			baseResponse.setData(
					BizGeneralResponse.builder().result(TypeHelper.castToString(result)).build());
		}
		return baseResponse;
	}

	@ApiOperation(value = "删除 安全条件确认 ", notes = "delete THazardConditionConfirmation By Id")
	@PutMapping(value = "/delete")
	public BaseResponse<BizGeneralResponse> deleteEntity(@RequestBody THazardConditionConfirmationDelParam deleteRequest){
		BaseResponse<BizGeneralResponse> baseResponse=new BaseResponse<>();
		if(ObjectHelper.isNotEmpty(deleteRequest)&&StringHelper.isNotEmpty(deleteRequest.getId())){
			// TODO 按需求添加数据去重，特殊值设定，业务异常
            THazardConditionConfirmation data= new THazardConditionConfirmation();
			data.setId(deleteRequest.getId());
			data.setStatus(BizConstants.STATUS_DELETE);
			boolean result= tHazardConditionConfirmationService.updateById(data);
			baseResponse.setData(
					BizGeneralResponse.builder().result(TypeHelper.castToString(result)).build());
		}
		return baseResponse;
	}

	@ApiOperation(value = "批量删除安全条件确认", notes = "delete THazardConditionConfirmation by batch Id")
	@PutMapping(value = "/batch_delete")
	public BaseResponse<BizGeneralResponse> deleteEntityBatch(
			@RequestBody THazardConditionConfirmationDelParam deleteRequest) {
		BaseResponse<BizGeneralResponse> baseResponse = new BaseResponse<>();
		if (ObjectHelper.isNotEmpty(deleteRequest) && (!deleteRequest.getIds().isEmpty())) {
            /* 批量删除 */
			List<THazardConditionConfirmation> tHazardConditionConfirmationList = new ArrayList<>();
            for(String id: deleteRequest.getIds()){
                THazardConditionConfirmation data= new THazardConditionConfirmation();
				data.setId(id);
				data.setStatus(BizConstants.STATUS_DELETE);
                tHazardConditionConfirmationList.add(data);
			}
			boolean result = tHazardConditionConfirmationService.updateBatchById(tHazardConditionConfirmationList);
			baseResponse.setData(
					BizGeneralResponse.builder().result(TypeHelper.castToString(result)).build());
		}
		return baseResponse;
	}

	@ApiOperation(value = "获取 安全条件确认 分页列表", notes = "List THazardConditionConfirmation with page")
	@GetMapping(value = "/list")
	public  BaseResponse<BaseResponseList<THazardConditionConfirmation>>listEntity(THazardConditionConfirmationParam param){
		BaseResponse<BaseResponseList<THazardConditionConfirmation>>baseResponse=new BaseResponse<>();
		Long page=
				StringHelper.isEmpty(param.getPage())?BizConstants.PAGE:Long.valueOf(param.getPage());
		Long limit=
				StringHelper.isEmpty(param.getLimit())?BizConstants.LIMIT:Long.valueOf(param.getLimit());
		Page<THazardConditionConfirmation> resultPage=new Page<>(page,limit);
		// TODO 根据需求修改查询条件及查询参数
		QueryWrapper<THazardConditionConfirmation> queryWrapper=this.createQuery(param);
		Page<THazardConditionConfirmation> resultList= tHazardConditionConfirmationService.page(resultPage,queryWrapper);
		BaseResponseList<THazardConditionConfirmation> baseResponseList=new BaseResponseList<>();
		baseResponseList.setData(resultList.getRecords());
		baseResponseList.setTotal(resultList.getTotal());
		baseResponse.setData(baseResponseList);
		return baseResponse;
	}

	@ApiOperation(value = "获取 安全条件确认 列表", notes = "List THazardConditionConfirmation all")
	@GetMapping(value = "/datas")
	public  BaseResponse<BaseResponseList<THazardConditionConfirmation>>listAllEntity(THazardConditionConfirmationParam param){
		BaseResponse<BaseResponseList<THazardConditionConfirmation>>baseResponse=new BaseResponse<>();
		// TODO 根据需求修改查询条件及查询参数
		QueryWrapper<THazardConditionConfirmation> queryWrapper=this.createQuery(param);
		List<THazardConditionConfirmation> resultList=tHazardConditionConfirmationService.list(queryWrapper);
		BaseResponseList<THazardConditionConfirmation> baseResponseList=new BaseResponseList<>();
		baseResponseList.setData(resultList);
		baseResponseList.setTotal(resultList.size());
		baseResponse.setData(baseResponseList);
		return baseResponse;
	}

    /* Private Methods */
	/**
     * 列表查询条件及查询参数
     */
	private QueryWrapper<THazardConditionConfirmation> createQuery(THazardConditionConfirmationParam queryParam){
		QueryWrapper<THazardConditionConfirmation> queryWrapper=new QueryWrapper<>();
		if(StringHelper.isNotEmpty(queryParam.getPlanId())){
			queryWrapper.eq(THazardConditionConfirmation.PLAN_ID,queryParam.getPlanId());
		}
		if(StringHelper.isNotEmpty(queryParam.getWorkTypeId())){
			queryWrapper.eq(THazardConditionConfirmation.WORK_TYPE_ID,queryParam.getWorkTypeId());
		}
		if(StringHelper.isNotEmpty(queryParam.getDepartmentSignature())){
			queryWrapper.eq(THazardConditionConfirmation.DEPARTMENT_SIGNATURE,queryParam.getDepartmentSignature());
		}
		if(StringHelper.isNotEmpty(queryParam.getSiteImage())){
			queryWrapper.eq(THazardConditionConfirmation.SITE_IMAGE,queryParam.getSiteImage());
		}
		if(StringHelper.isNotEmpty(queryParam.getWorkSiteResponsibleSignature())){
			queryWrapper.eq(THazardConditionConfirmation.WORK_SITE_RESPONSIBLE_SIGNATURE,queryParam.getWorkSiteResponsibleSignature());
		}
		if(ObjectHelper.isNotEmpty(queryParam.getSignatureTime())){
			queryWrapper.eq(THazardConditionConfirmation.SIGNATURE_TIME,queryParam.getSignatureTime());
		}
		if(ObjectHelper.isNotEmpty(queryParam.getBatch())){
			queryWrapper.eq(THazardConditionConfirmation.BATCH,queryParam.getBatch());
		}
		if (StringHelper.isNotEmpty(queryParam.getStatus())) {
			queryWrapper.eq(THazardConditionConfirmation.STATUS, queryParam.getStatus());
		} else {
			queryWrapper.ne(THazardConditionConfirmation.STATUS, BizConstants.STATUS_DELETE);
		}
		if (StringHelper.isNotEmpty(queryParam.getOrderBy())){
			if(StringHelper.isNotEmpty(queryParam.getOrderType())
					&&BizConstants.ASC.equals(queryParam.getOrderType())){
				queryWrapper.orderByAsc(queryParam.getOrderBy());
			}else{
				queryWrapper.orderByDesc(queryParam.getOrderBy());
			}
		}else{
			queryWrapper.orderByDesc(THazardConditionConfirmation.UPDATE_DATE);
		}
		return queryWrapper;
	}
}
