package com.testor.module.hazard.controller;

import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import lombok.extern.slf4j.Slf4j;
import com.tongtech.tfw.backend.core.helper.StringHelper;
import com.tongtech.tfw.backend.core.helper.ObjectHelper;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RestController;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.tongtech.tfw.backend.common.biz.constants.BizConstants;
import com.tongtech.tfw.backend.common.biz.models.BaseResponse;
import com.tongtech.tfw.backend.common.biz.models.BaseResponse;
import com.tongtech.tfw.backend.common.biz.models.BaseResponseList;
import com.tongtech.tfw.backend.common.biz.models.BizGeneralResponse;
import com.tongtech.tfw.backend.common.models.exceptions.ApiException;
import com.tongtech.tfw.backend.common.models.supers.SuperController;
import com.tongtech.tfw.backend.core.helper.IdHelper;
import com.tongtech.tfw.backend.core.helper.TypeHelper;
import com.tongtech.tfw.backend.core.helper.bean.BeanHelper;

import com.testor.module.hazard.model.domain.THazardDisclosureDetails;
import com.testor.module.hazard.model.dto.THazardDisclosureDetailsParam;
import com.testor.module.hazard.model.dto.THazardDisclosureDetailsDelParam;
import com.testor.module.hazard.service.THazardDisclosureDetailsService;

/**
 * 危险作业-交底信息明细Controller
 *
 * @author testor-framework
 * @date 2024-12-28 19:52:54
 */
@RestController
@RequestMapping("/hazard/disclosureDetails")
@Api(value = "THazardDisclosureDetails", tags = "危险作业-交底信息明细")
@Slf4j
public class THazardDisclosureDetailsController extends SuperController
{
    @Autowired
    private THazardDisclosureDetailsService tHazardDisclosureDetailsService;

    /* Generated Method*/
	@ApiOperation(value = "新增 危险作业-交底信息明细", notes = "Add THazardDisclosureDetails")
	@PostMapping(value = "/add")
	public BaseResponse<THazardDisclosureDetails>addEntity(@RequestBody THazardDisclosureDetails addRequest) {
		BaseResponse<THazardDisclosureDetails> baseResponse=new BaseResponse<>();
		if(ObjectHelper.isNotEmpty(addRequest)){
			// TODO 按需求添加数据去重，特殊值设定，业务异常
			String id = IdHelper.getId32bit();
            THazardDisclosureDetails data=BeanHelper.beanToBean(addRequest,  THazardDisclosureDetails.class);
			data.setId(id);
			boolean result= tHazardDisclosureDetailsService.save(data);
			if(result){
                THazardDisclosureDetails newEntity = new THazardDisclosureDetails();
				newEntity.setId(id);
				baseResponse.setData(newEntity);
			}
		}
		return baseResponse;
	}

	@ApiOperation(value = "获取 危险作业-交底信息明细 ", notes = "Get THazardDisclosureDetails By Id")
	@GetMapping(value = "/get")
	public BaseResponse<THazardDisclosureDetails> getById(String id){
		BaseResponse<THazardDisclosureDetails> baseResponse=new BaseResponse<>();
		if(StringHelper.isNotEmpty(id)){
			// TODO 按需求添加业务异常判断
            THazardDisclosureDetails data= tHazardDisclosureDetailsService.getById(id);
			baseResponse.setData(data);
		}
		return baseResponse;
	}

	@ApiOperation(value = "修改 危险作业-交底信息明细 ", notes = "Update THazardDisclosureDetails By Id")
	@PutMapping(value = "/update")
	public BaseResponse<BizGeneralResponse> updateEntity(@RequestBody THazardDisclosureDetails updateRequest){
		BaseResponse<BizGeneralResponse> baseResponse=new BaseResponse<>();
		if(ObjectHelper.isNotEmpty(updateRequest)&&StringHelper.isNotEmpty(updateRequest.getId())){
			// TODO 按需求添加数据去重，特殊值设定，业务异常
            THazardDisclosureDetails data=BeanHelper.beanToBean(updateRequest, THazardDisclosureDetails.class);
			boolean result= tHazardDisclosureDetailsService.updateById(data);
			baseResponse.setData(
					BizGeneralResponse.builder().result(TypeHelper.castToString(result)).build());
		}
		return baseResponse;
	}

	@ApiOperation(value = "删除 危险作业-交底信息明细 ", notes = "delete THazardDisclosureDetails By Id")
	@PutMapping(value = "/delete")
	public BaseResponse<BizGeneralResponse> deleteEntity(@RequestBody THazardDisclosureDetailsDelParam deleteRequest){
		BaseResponse<BizGeneralResponse> baseResponse=new BaseResponse<>();
		if(ObjectHelper.isNotEmpty(deleteRequest)&&StringHelper.isNotEmpty(deleteRequest.getId())){
			// TODO 按需求添加数据去重，特殊值设定，业务异常
            THazardDisclosureDetails data= new THazardDisclosureDetails();
			data.setId(deleteRequest.getId());
			data.setStatus(BizConstants.STATUS_DELETE);
			boolean result= tHazardDisclosureDetailsService.updateById(data);
			baseResponse.setData(
					BizGeneralResponse.builder().result(TypeHelper.castToString(result)).build());
		}
		return baseResponse;
	}

	@ApiOperation(value = "批量删除危险作业-交底信息明细", notes = "delete THazardDisclosureDetails by batch Id")
	@PutMapping(value = "/batch_delete")
	public BaseResponse<BizGeneralResponse> deleteEntityBatch(
			@RequestBody THazardDisclosureDetailsDelParam deleteRequest) {
		BaseResponse<BizGeneralResponse> baseResponse = new BaseResponse<>();
		if (ObjectHelper.isNotEmpty(deleteRequest) && (!deleteRequest.getIds().isEmpty())) {
            /* 批量删除 */
			List<THazardDisclosureDetails> tHazardDisclosureDetailsList = new ArrayList<>();
            for(String id: deleteRequest.getIds()){
                THazardDisclosureDetails data= new THazardDisclosureDetails();
				data.setId(id);
				data.setStatus(BizConstants.STATUS_DELETE);
                tHazardDisclosureDetailsList.add(data);
			}
			boolean result = tHazardDisclosureDetailsService.updateBatchById(tHazardDisclosureDetailsList);
			baseResponse.setData(
					BizGeneralResponse.builder().result(TypeHelper.castToString(result)).build());
		}
		return baseResponse;
	}

	@ApiOperation(value = "获取 危险作业-交底信息明细 分页列表", notes = "List THazardDisclosureDetails with page")
	@GetMapping(value = "/list")
	public  BaseResponse<BaseResponseList<THazardDisclosureDetails>>listEntity(THazardDisclosureDetailsParam param){
		BaseResponse<BaseResponseList<THazardDisclosureDetails>>baseResponse=new BaseResponse<>();
		Long page=
				StringHelper.isEmpty(param.getPage())?BizConstants.PAGE:Long.valueOf(param.getPage());
		Long limit=
				StringHelper.isEmpty(param.getLimit())?BizConstants.LIMIT:Long.valueOf(param.getLimit());
		Page<THazardDisclosureDetails> resultPage=new Page<>(page,limit);
		// TODO 根据需求修改查询条件及查询参数
		QueryWrapper<THazardDisclosureDetails> queryWrapper=this.createQuery(param);
		Page<THazardDisclosureDetails> resultList= tHazardDisclosureDetailsService.page(resultPage,queryWrapper);
		BaseResponseList<THazardDisclosureDetails> baseResponseList=new BaseResponseList<>();
		baseResponseList.setData(resultList.getRecords());
		baseResponseList.setTotal(resultList.getTotal());
		baseResponse.setData(baseResponseList);
		return baseResponse;
	}

	@ApiOperation(value = "获取 危险作业-交底信息明细 列表", notes = "List THazardDisclosureDetails all")
	@GetMapping(value = "/datas")
	public  BaseResponse<BaseResponseList<THazardDisclosureDetails>>listAllEntity(THazardDisclosureDetailsParam param){
		BaseResponse<BaseResponseList<THazardDisclosureDetails>>baseResponse=new BaseResponse<>();
		// TODO 根据需求修改查询条件及查询参数
		QueryWrapper<THazardDisclosureDetails> queryWrapper=this.createQuery(param);
		List<THazardDisclosureDetails> resultList=tHazardDisclosureDetailsService.list(queryWrapper);
		BaseResponseList<THazardDisclosureDetails> baseResponseList=new BaseResponseList<>();
		baseResponseList.setData(resultList);
		baseResponseList.setTotal(resultList.size());
		baseResponse.setData(baseResponseList);
		return baseResponse;
	}

    /* Private Methods */
	/**
     * 列表查询条件及查询参数
     */
	private QueryWrapper<THazardDisclosureDetails> createQuery(THazardDisclosureDetailsParam queryParam){
		QueryWrapper<THazardDisclosureDetails> queryWrapper=new QueryWrapper<>();
		if(StringHelper.isNotEmpty(queryParam.getDisclosureId())){
			queryWrapper.eq(THazardDisclosureDetails.DISCLOSURE_ID,queryParam.getDisclosureId());
		}
		if(StringHelper.isNotEmpty(queryParam.getElement())){
			queryWrapper.eq(THazardDisclosureDetails.ELEMENT,queryParam.getElement());
		}
		if(StringHelper.isNotEmpty(queryParam.getContent())){
			queryWrapper.eq(THazardDisclosureDetails.CONTENT,queryParam.getContent());
		}
		if(StringHelper.isNotEmpty(queryParam.getIsDisclosure())){
			queryWrapper.eq(THazardDisclosureDetails.IS_DISCLOSURE,queryParam.getIsDisclosure());
		}
		if(ObjectHelper.isNotEmpty(queryParam.getSort())){
			queryWrapper.eq(THazardDisclosureDetails.SORT,queryParam.getSort());
		}
		if (StringHelper.isNotEmpty(queryParam.getStatus())) {
			queryWrapper.eq(THazardDisclosureDetails.STATUS, queryParam.getStatus());
		} else {
			queryWrapper.ne(THazardDisclosureDetails.STATUS, BizConstants.STATUS_DELETE);
		}
		if (StringHelper.isNotEmpty(queryParam.getOrderBy())){
			if(StringHelper.isNotEmpty(queryParam.getOrderType())
					&&BizConstants.ASC.equals(queryParam.getOrderType())){
				queryWrapper.orderByAsc(queryParam.getOrderBy());
			}else{
				queryWrapper.orderByDesc(queryParam.getOrderBy());
			}
		}else{
			queryWrapper.orderByDesc(THazardDisclosureDetails.UPDATE_DATE);
		}
		return queryWrapper;
	}
}
