package com.testor.module.hazard.model.domain;

import java.time.LocalDateTime;

import com.testor.common.annotation.Translation;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;
import lombok.experimental.Accessors;
import lombok.experimental.SuperBuilder;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.baomidou.mybatisplus.annotation.TableName;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.tongtech.tfw.backend.common.models.supers.SuperModel;


/**
 * 危险作业风险分析明细对象 t_hazard_assessment_details
 * 
 * @author testor-framework
 * @date 2024-12-24 18:46:00
 */
@Data
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
@TableName("t_hazard_assessment_details")
@ApiModel(value = "THazardAssessmentDetails对象" , description = "")
@SuperBuilder
@AllArgsConstructor
@NoArgsConstructor
public class THazardAssessmentDetails extends SuperModel
{
    private static final long serialVersionUID = 1L;

  @TableId("id")
  private String id;
/**
 * 风险分析id
 */
  @ApiModelProperty(value = "风险分析id")

  @TableField("assessment_id")
  private String assessmentId;
/**
 * 阶段
 */
  @ApiModelProperty(value = "阶段")

  @TableField("stage")
  private String stage;
/**
 * 作业步骤
 */
  @ApiModelProperty(value = "作业步骤")

  @TableField("work_step")
  private String workStep;
/**
 * 存在的主要风险
 */
  @ApiModelProperty(value = "存在的主要风险")

  @TableField("major_risk")
  private String majorRisk;
/**
 * 后果
 */
  @ApiModelProperty(value = "后果")

  @TableField("consequence")
  private String consequence;
/**
 * 主要控制措施
 */
  @ApiModelProperty(value = "主要控制措施")

  @TableField("control_measures")
  private String controlMeasures;
/**
 * 是否满足 0=否,1=是
 */
  @ApiModelProperty(value = "是否满足 0=否,1=是")

  @TableField("is_satisfied")
  private String isSatisfied;

  /**
   * 排序
   */
  @ApiModelProperty(value = "排序" , example = "0")

  @TableField("sort")
  private Long sort;

  @TableField(exist = false)
  @Translation(other = "0=否,1=是,2=不涉及")
  private String isSatisfiedName;

  public static final String ID ="id";
  public static final String ASSESSMENT_ID ="assessment_id";
  public static final String STAGE ="stage";
  public static final String WORK_STEP ="work_step";
  public static final String MAJOR_RISK ="major_risk";
  public static final String CONSEQUENCE ="consequence";
  public static final String CONTROL_MEASURES ="control_measures";
  public static final String IS_SATISFIED ="is_satisfied";
  public static final String SORT ="sort";


}
