package com.testor.module.hazard.model.domain;

import java.time.LocalDateTime;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;
import lombok.experimental.Accessors;
import lombok.experimental.SuperBuilder;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.baomidou.mybatisplus.annotation.TableName;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.tongtech.tfw.backend.common.models.supers.SuperModel;


/**
 * 危险作业-交底信息对象 t_hazard_disclosure
 * 
 * @author testor-framework
 * @date 2024-12-28 19:52:55
 */
@Data
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
@TableName("t_hazard_disclosure")
@ApiModel(value = "THazardDisclosure对象" , description = "")
@SuperBuilder
@AllArgsConstructor
@NoArgsConstructor
public class THazardDisclosure extends SuperModel
{
    private static final long serialVersionUID = 1L;

  @TableId("id")
  private String id;
/**
 * 计划id
 */
  @ApiModelProperty(value = "计划id")

  @TableField("plan_id")
  private String planId;
  /**
   * 作业类型id
   */
  @ApiModelProperty(value = "作业类型id")

  @TableField("work_type_id")
  private String workTypeId;

/**
 * 现场处置措施
 */
  @ApiModelProperty(value = "现场处置措施")

  @TableField("on_site_measures")
  private String onSiteMeasures;
/**
 * 现场处置措施文件
 */
  @ApiModelProperty(value = "现场处置措施文件")

  @TableField("on_site_measures_file")
  private String onSiteMeasuresFile;
/**
 * 安全注意事项


 */
  @ApiModelProperty(value = "安全注意事项")

  @TableField("safety_precautions")
  private String safetyPrecautions;
/**
 * 安全注意事项文件
 */
  @ApiModelProperty(value = "安全注意事项文件")

  @TableField("safety_precautions_file")
  private String safetyPrecautionsFile;
  /**
   * 自救互救措施
   */
  @ApiModelProperty(value = "自救互救措施")

  @TableField("rescue_measures")
  private String rescueMeasures;

  /**
   * 自救互救措施文件
   */
  @ApiModelProperty(value = "自救互救措施文件")

  @TableField("rescue_measures_file")
  private String rescueMeasuresFile;

/**
 * 自报告 流程及 联系人
 */
  @ApiModelProperty(value = "自报告 流程及 联系人 ")

  @TableField("contact_person")
  private String contactPerson;
/**
 * 自报告 流程及 联系人 文件
 */
  @ApiModelProperty(value = "自报告 流程及 联系人 文件")

  @TableField("contact_person_file")
  private String contactPersonFile;
/**
 * 应急物资
 */
  @ApiModelProperty(value = "应急物资")

  @TableField("emergency_supplies")
  private String emergencySupplies;
/**
 * 应急物资文件
 */
  @ApiModelProperty(value = "应急物资文件")

  @TableField("emergency_supplies_file")
  private String emergencySuppliesFile;
/**
 * 交底人签字
 */
  @ApiModelProperty(value = "交底人签字")

  @TableField("disclosure_person_sign")
  private String disclosurePersonSign;
/**
 * 被交底人签字
 */
  @ApiModelProperty(value = "被交底人签字")

  @TableField("recipient_signature")
  private String recipientSignature;

  /**
   * 交底开始时间
   */
  @ApiModelProperty(value = "交底开始时间")

  @TableField("disclosure_start_time")
  private String disclosureStartTime;

  /**
   * 交底结束时间
   */
  @ApiModelProperty(value = "交底结束时间")

  @TableField("disclosure_end_time")
  private String disclosureEndTime;

  /**
   * 批次（第几次安全交底）
   */
  @ApiModelProperty(value = "批次（第几次安全交底）")
  @TableField("batch")
  private Integer batch;



  public static final String ID ="id";
  public static final String PLAN_ID ="plan_id";
  public static final String ON_SITE_MEASURES ="on_site_measures";
  public static final String ON_SITE_MEASURES_FILE ="on_site_measures_file";
  public static final String SAFETY_PRECAUTIONS ="safety_precautions";
  public static final String SAFETY_PRECAUTIONS_FILE ="safety_precautions_file";
  public static final String CONTACT_PERSON ="contact_person";
  public static final String CONTACT_PERSON_FILE ="contact_person_file";
  public static final String EMERGENCY_SUPPLIES ="emergency_supplies";
  public static final String EMERGENCY_SUPPLIES_FILE ="emergency_supplies_file";
  public static final String DISCLOSURE_PERSON_SIGN ="disclosure_person_sign";
  public static final String RECIPIENT_SIGNATURE ="recipient_signature";
  public static final String BATH ="batch";


}
