package com.testor.module.hazard.model.dto;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import java.util.List;
import com.testor.module.hazard.model.domain.THazardWorkPlan;

/**
 * 危险作业计划 删除参数对象
 *
 * @author testor-framework
 * @date 2024-12-19 10:39:26
 */

@Data
@ApiModel(value = "THazardWorkPlan 列表查询参数对象")
@EqualsAndHashCode(callSuper = true)
public class THazardWorkPlanParam extends THazardWorkPlan {
	private static final long serialVersionUID = 1L;
	@ApiModelProperty(value = "每页数量")
	private String limit;

	@ApiModelProperty(value = "当前页数")
	private String page;

	@ApiModelProperty(value = "排序字段")
	private String orderBy;

	@ApiModelProperty(value = "排序方式")
	private String orderType;

	/**
	 * 上报起始时间
	 */
	@ApiModelProperty(value = "作业上报时间-起始")
	private String reportStartDate;

	/**
	 * 上报截止时间
	 */
	@ApiModelProperty(value = "作业上报时间-截止")
	private String reportEndDate;

	@ApiModelProperty(value = "单位id，专用于作业统计模块明细导出")
	private String statOrgId;

	@ApiModelProperty(value = "排除的作业状态条件")
	private String neWorkStatus;

	@ApiModelProperty(value = "查询内容，用于app端作业计划列表输入框查询条件")
	private String queryContent;

}
