package com.testor.module.hire.entity;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableLogic;
import com.baomidou.mybatisplus.annotation.TableName;
import java.io.Serializable;
import java.time.LocalDateTime;
import java.util.Date;

import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;
import lombok.experimental.Accessors;
import org.springframework.format.annotation.DateTimeFormat;

/**
 * <p>
 * 租赁库管理-准入信息
 * </p>
 *
 * @author caoqiang
 * @since 2024-08-30
 */
@Getter
@Setter
@Accessors(chain = true)
@TableName("t_hire_depository_access_info")
public class DepositoryAccessInfo implements Serializable {

    private static final long serialVersionUID = 1L;

    /**
     * 主键ID
     */
    @TableId(value = "id")
    private String id;

    /**
     * 租赁库管理id
     */
    @TableField("hire_depository_manage_base_id")
    private String hireDepositoryManageBaseId;

    /**
     * 资信准入评级得分
     */
    @TableField("access_grade_score")
    @ApiModelProperty(value = "资信准入评级得分 ")
    private String accessGradeScore;

    /**
     * 仓储准入得分
     */
    @TableField("access_score")
    @ApiModelProperty(value = "仓储准入得分 ")
    private String accessScore;

    /**
     * 安全环保准入得分
     */
    @TableField("access_safety_score")
    @ApiModelProperty(value = "安全环保准入得分 ")
    private String accessSafetyScore;

    /**
     * 准入最终得分
     */
    @TableField("access_final_score")
    @ApiModelProperty(value = "准入最终得分 ")
    private String accessFinalScore;

    /**
     * 签约有效截止日期
     */
    @TableField("access_sign_end_time")
    @ApiModelProperty(value = "签约有效截止日期 ")
    @JsonFormat(timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private Date accessSignEndTime;

    /**
     * 租赁方式code
     */
    @TableField("access_lease_method_code")
    @ApiModelProperty(value = "租赁方式code ")
    private String accessLeaseMethodCode;

    /**
     * 租赁方式text
     */
    @TableField("access_lease_method_name")
    @ApiModelProperty(value = "租赁方式text ")
    private String accessLeaseMethodName;

    /**
     * 拟租赁期限（年）
     */
    @TableField("access_lease_term")
    @ApiModelProperty(value = "拟租赁期限（年）")
    private String accessLeaseTerm;

    /**
     * 租赁类型code
     */
    @TableField("access_lease_type_code")
    @ApiModelProperty(value = "租赁类型code")
    private String accessLeaseTypeCode;

    /**
     * 租赁类型text
     */
    @TableField("access_lease_type_name")
    @ApiModelProperty(value = "租赁类型text")
    private String accessLeaseTypeName;

    /**
     * 库点总仓容（吨）
     */
    @TableField("access_total_capacity")
    @ApiModelProperty(value = "库点总仓容（吨）")
    private String accessTotalCapacity;

    /**
     * 租赁仓容（吨）
     */
    @TableField("access_lease_capacity")
    @ApiModelProperty(value = "租赁仓容（吨）")
    private String accessLeaseCapacity;

    /**
     * 拟合作总量（吨）
     */
    @TableField("access_interact_total_capacity")
    @ApiModelProperty(value = "拟合作总量（吨）")
    private String accessInteractTotalCapacity;

    /**
     * 合作品种和总量JSON数组
     */
    @TableField("access_crops_arry")
    @ApiModelProperty(value = "合作品种和总量JSON数组")
    private String accessCropsArry;

    /**
     * 员工和联系电话JSON数组
     */
    @TableField("access_person_arry")
    @ApiModelProperty(value = "员工和联系电话JSON数组")
    private String accessPersonArry;

    /**
     * 状态：0正常 1删除 2停用
     */
    @TableField("status")
    private String status;

    /**
     * 创建者
     */
    @TableField("create_by")
    private String createBy;

    /**
     * 创建时间
     */
    @TableField("create_date")
    @JsonFormat(timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private Date createDate;

    /**
     * 最后一次更新者
     */
    @TableField("update_by")
    private String updateBy;

    /**
     * 最后一次更新时间
     */
    @TableField("update_date")
    @JsonFormat(timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private Date updateDate;

    /**
     * 租赁开始时间
     */
    @TableField("access_hire_start_time")
    @ApiModelProperty(value = "租赁开始时间 ")
    @JsonFormat(timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private Date accessHireStartTime;

    /**
     * 租赁结束时间
     */
    @TableField("access_hire_end_time")
    @ApiModelProperty(value = "租赁结束时间 ")
    @JsonFormat(timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private Date accessHireEndTime;


    public static final String ID = "id";

    public static final String HIRE_DEPOSITORY_MANAGE_BASE_ID = "hire_depository_manage_base_id";

    public static final String ACCESS_GRADE_SCORE = "access_grade_score";

    public static final String ACCESS_SCORE = "access_score";

    public static final String ACCESS_SAFETY_SCORE = "access_safety_score";

    public static final String ACCESS_FINAL_SCORE = "access_final_score";

    public static final String ACCESS_SIGN_END_TIME = "access_sign_end_time";

    public static final String ACCESS_LEASE_METHOD_CODE = "access_lease_method_code";

    public static final String ACCESS_LEASE_METHOD_NAME = "access_lease_method_name";

    public static final String ACCESS_LEASE_TERM = "access_lease_term";

    public static final String ACCESS_LEASE_TYPE_CODE = "access_lease_type_code";

    public static final String ACCESS_LEASE_TYPE_NAME = "access_lease_type_name";

    public static final String ACCESS_TOTAL_CAPACITY = "access_total_capacity";

    public static final String ACCESS_LEASE_CAPACITY = "access_lease_capacity";

    public static final String ACCESS_INTERACT_TOTAL_CAPACITY = "access_interact_total_capacity";

    public static final String ACCESS_CROPS_ARRY = "access_crops_arry";

    public static final String ACCESS_PERSON_ARRY = "access_person_arry";

    public static final String STATUS = "status";

    public static final String CREATE_BY = "create_by";

    public static final String CREATE_DATE = "create_date";

    public static final String UPDATE_BY = "update_by";

    public static final String UPDATE_DATE = "update_date";

    public static final String ACCESS_HIRE_START_TIME = "access_hire_start_time";

    public static final String ACCESS_HIRE_END_TIME = "access_hire_end_time";

}
