package com.testor.module.hire.entity;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableLogic;
import com.baomidou.mybatisplus.annotation.TableName;
import java.io.Serializable;
import java.time.LocalDateTime;
import java.util.Date;

import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;
import lombok.experimental.Accessors;

/**
 * <p>
 * 租赁库管理-附件
 * </p>
 *
 * @author caoqiang
 * @since 2024-08-29
 */
@Getter
@Setter
@Accessors(chain = true)
@TableName("t_hire_depository_file_info")
public class DepositoryFileInfo implements Serializable {

    private static final long serialVersionUID = 1L;

    /**
     * 主键ID
     */
    @TableId(value = "id")
    private String id;

    /**
     * 租赁库管理id
     */
    @TableField("hire_depository_manage_base_id")
    private String hireDepositoryManageBaseId;

    /**
     * 准入评分表，使用英文,隔开 
     */
    @TableField("file_score_path")
    @ApiModelProperty(value = "准入评分表，使用英文,隔开 ")
    private String fileScorePath;

    /**
     * 风险准入证明材料
     */
    @TableField("file_risk_path")
    @ApiModelProperty(value = "风险准入证明材料 ")
    private String fileRiskPath;

    /**
     * 仓储准入证明材料
     */
    @TableField("file_depository_path")
    @ApiModelProperty(value = "仓储准入证明材料 ")
    private String fileDepositoryPath;

    /**
     * 安环准入证明材料
     */
    @TableField("file_safety_path")
    @ApiModelProperty(value = "安环准入证明材料 ")
    private String fileSafetyPath;

    /**
     * 财务准入证明材料
     */
    @TableField("file_finance_path")
    @ApiModelProperty(value = "财务准入证明材料 ")
    private String fileFinancePath;

    /**
     * 人力准入证明材料
     */
    @TableField("file_persion_path")
    @ApiModelProperty(value = "人力准入证明材料 ")
    private String filePersionPath;

    /**
     * 其他准入证明材料
     */
    @TableField("file_other_path")
    @ApiModelProperty(value = "其他准入证明材料 ")
    private String fileOtherPath;

    /**
     * 状态：0正常 1删除 2停用
     */
    @TableField("status")
    private String status;

    /**
     * 创建者
     */
    @TableField("create_by")
    private String createBy;

    /**
     * 创建时间
     */
    @TableField("create_date")
    private Date createDate;

    /**
     * 最后一次更新者
     */
    @TableField("update_by")
    private String updateBy;

    /**
     * 最后一次更新时间
     */
    @TableField("update_date")
    private Date updateDate;


    public static final String ID = "id";

    public static final String HIRE_DEPOSITORY_MANAGE_BASE_ID = "hire_depository_manage_base_id";

    public static final String FILE_SCORE_PATH = "file_score_path";

    public static final String FILE_RISK_PATH = "file_risk_path";

    public static final String FILE_DEPOSITORY_PATH = "file_depository_path";

    public static final String FILE_SAFETY_PATH = "file_safety_path";

    public static final String FILE_FINANCE_PATH = "file_finance_path";

    public static final String FILE_PERSION_PATH = "file_persion_path";

    public static final String FILE_OTHER_PATH = "file_other_path";

    public static final String STATUS = "status";

    public static final String CREATE_BY = "create_by";

    public static final String CREATE_DATE = "create_date";

    public static final String UPDATE_BY = "update_by";

    public static final String UPDATE_DATE = "update_date";

}
