package com.testor.module.hire.entity;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableLogic;
import com.baomidou.mybatisplus.annotation.TableName;
import java.io.Serializable;
import java.time.LocalDateTime;
import java.util.Date;

import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;
import lombok.experimental.Accessors;

/**
 * <p>
 * 租赁库管理-库点基本信息
 * </p>
 *
 * @author caoqiang
 * @since 2024-08-29
 */
@Getter
@Setter
@Accessors(chain = true)
@TableName("t_hire_depository_info")
public class DepositoryInfo implements Serializable {

    private static final long serialVersionUID = 1L;

    /**
     * 主键ID
     */
    @TableId(value = "id")
    private String id;

    /**
     * 租赁库管理id
     */
    @TableField("hire_depository_manage_base_id")
    private String hireDepositoryManageBaseId;

    /**
     * 库点全称
     */
    @TableField("depository_full_name")
    @ApiModelProperty(value = "库点全称")
    private String depositoryFullName;

    /**
     * 库点简称
     */
    @TableField("depository_short_name")
    @ApiModelProperty(value = "库点简称")
    private String depositoryShortName;

    /**
     * 银行账号
     */
    @TableField("depository_bank_code")
    @ApiModelProperty(value = "银行账号")
    private String depositoryBankCode;

    /**
     * 准入说明
     */
    @TableField("depository_desc")
    @ApiModelProperty(value = "准入说明")
    private String depositoryDesc;

    /**
     * 所在地区，省份code
     */
    @TableField("depository_province_code")
    @ApiModelProperty(value = "所在地区，省份code")
    private String depositoryProvinceCode;

    /**
     * 所在地区，省份
     */
    @TableField("depository_province_name")
    @ApiModelProperty(value = "所在地区，省份")
    private String depositoryProvinceName;

    /**
     * 所在地区，市code
     */
    @TableField("depository_city_code")
    @ApiModelProperty(value = "所在地区，市code")
    private String depositoryCityCode;

    /**
     * 所在地区，市名称
     */
    @TableField("depository_city_name")
    @ApiModelProperty(value = "所在地区，市名称")
    private String depositoryCityName;

    /**
     * 所在地区，区县code
     */
    @TableField("depository_county_code")
    @ApiModelProperty(value = "所在地区，区县code")
    private String depositoryCountyCode;

    /**
     * 所在地区，区县
     */
    @TableField("depository_county_name")
    @ApiModelProperty(value = "所在地区，区县")
    private String depositoryCountyName;

    /**
     * 存粮地址
     */
    @TableField("depository_address")
    @ApiModelProperty(value = "存粮地址")
    private String depositoryAddress;

    /**
     * 状态：0正常 1删除 2停用
     */
    @TableField("status")
    private String status;

    /**
     * 创建者
     */
    @TableField("create_by")
    private String createBy;

    /**
     * 创建时间
     */
    @TableField("create_date")
    private Date createDate;

    /**
     * 最后一次更新者
     */
    @TableField("update_by")
    private String updateBy;

    /**
     * 最后一次更新时间
     */
    @TableField("update_date")
    private Date updateDate;


    public static final String ID = "id";

    public static final String HIRE_DEPOSITORY_MANAGE_BASE_ID = "hire_depository_manage_base_id";

    public static final String DEPOSITORY_FULL_NAME = "depository_full_name";

    public static final String DEPOSITORY_SHORT_NAME = "depository_short_name";

    public static final String DEPOSITORY_BANK_CODE = "depository_bank_code";

    public static final String DEPOSITORY_DESC = "depository_desc";

    public static final String DEPOSITORY_PROVINCE_CODE = "depository_province_code";

    public static final String DEPOSITORY_PROVINCE_NAME = "depository_province_name";

    public static final String DEPOSITORY_CITY_CODE = "depository_city_code";

    public static final String DEPOSITORY_CITY_NAME = "depository_city_name";

    public static final String DEPOSITORY_COUNTY_CODE = "depository_county_code";

    public static final String DEPOSITORY_COUNTY_NAME = "depository_county_name";

    public static final String DEPOSITORY_ADDRESS = "depository_address";

    public static final String STATUS = "status";

    public static final String CREATE_BY = "create_by";

    public static final String CREATE_DATE = "create_date";

    public static final String UPDATE_BY = "update_by";

    public static final String UPDATE_DATE = "update_date";

}
