package com.testor.module.iam.model.domain;

import com.baomidou.mybatisplus.annotation.TableName;
import com.fasterxml.jackson.annotation.JsonFormat;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;
import lombok.experimental.Accessors;
import lombok.experimental.SuperBuilder;
import org.springframework.format.annotation.DateTimeFormat;

import java.util.Date;

/**
 * @ClassName: IamUserMapping
 * @Description: TODO
 * @Author: lm
 * @CreateTime: 2023/12/29 10:09
 * @Version: 1.0
 */
@Data
@Accessors(chain = true)
@EqualsAndHashCode()
@TableName("iam_user_mapping")
@SuperBuilder
@AllArgsConstructor
@NoArgsConstructor
public class IamUserMapping {

    /**
     * 用户id
     */
    private String userId;

    /**
     * IAM用户id
     */
    private String iamUserId;

    /**
     * 绑定时间
     */
    @JsonFormat(timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private Date bindTime;
}
