package com.testor.module.lease.service;


import com.testor.module.lease.model.domain.TLeaseBank;
import com.tongtech.tfw.backend.common.biz.models.BaseResponse;
import com.tongtech.tfw.backend.common.biz.models.BizGeneralResponse;
import com.tongtech.tfw.backend.common.models.supers.SuperService;

import java.util.List;

/**
 * 租赁库管理关系Service接口
 *
 * @author testor-framework
 * @date 2022-07-20 10:09:54
 */
public interface TLeaseBankService extends SuperService<TLeaseBank> {

    BaseResponse<TLeaseBank> addEntity(TLeaseBank addRequest) throws Exception;

    BaseResponse<TLeaseBank> getDetail(String id);

    BaseResponse<BizGeneralResponse> updateEntity(TLeaseBank updateRequest);

    BaseResponse<List<TLeaseBank>> getOrgLease();

    // 获取危险源总数
    int getRiskRourceNum(List<String> orgs);

    // 获取重大危险源
    int getMajor(List<String> orgs);

    // 获取风险点
    int getRiskPoint(List<String> orgs);
}
