package com.testor.module.mq.consumer;

import cn.hutool.core.bean.BeanUtil;
import com.alibaba.fastjson.JSON;
import com.rabbitmq.client.Channel;
import com.testor.module.mq.domain.WeatherDomain;
import com.testor.module.mq.service.WeatherService;
import com.testor.module.mq.vo.WeatherEntity;
import groovy.util.logging.Log;
import groovy.util.logging.Slf4j;
import org.springframework.amqp.core.Message;
import org.springframework.amqp.rabbit.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.io.IOException;
import java.util.Map;

@Component
@Slf4j
@RabbitListener(queues = "weather-02")
public class FanoutMsgConsumer {

    @Autowired
    private WeatherService weatherService;

    @RabbitHandler(isDefault = true)
    public void process(Map param, Message message, Channel channel) throws IOException {
        WeatherDomain weatherDomain = new WeatherDomain();
        WeatherEntity weatherEntity = JSON.parseObject(JSON.toJSONString(param), WeatherEntity.class);
        BeanUtil.copyProperties(weatherEntity,weatherDomain);
        boolean save = weatherService.save(weatherDomain);
        if (save){
            weatherService.pushWeatherWarningMsg(weatherDomain);
            channel.basicAck(message.getMessageProperties().getDeliveryTag(),false);

        }
    }
}
