package com.testor.module.notice.model.domain;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.tongtech.tfw.backend.common.models.supers.SuperModel;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;
import lombok.experimental.Accessors;
import lombok.experimental.SuperBuilder;


/**
 * notice对象 t_sys_org
 * 
 * @author tong-framework
 * @date 2022-04-27 18:10:12
 */
@Data
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
@TableName("t_sys_org")
@ApiModel(value = "t_sys_org对象" , description = "")
@SuperBuilder
@AllArgsConstructor
@NoArgsConstructor
public class TSysOrg extends SuperModel
{
    private static final long serialVersionUID = 1L;
/**
 * 组织机构id
 */
  @ApiModelProperty(value = "组织机构id")

  @TableId("org_id")
  private String orgId;
/**
 * 父级id
 */
  @ApiModelProperty(value = "父级id")

  @TableField("parent_id")
  private String parentId;
/**
 * 所有父级id用逗号分割
 */
  @ApiModelProperty(value = "所有父级ids")

  @TableField("parent_ids")
  private String parentIds;
/**
 * 排序号
 */
  @ApiModelProperty(value = "排序号")

  @TableField("tree_sort")
  private String treeSort;

  /**
   * 级别
   */
  @ApiModelProperty(value = "级别")
  @TableField("tree_level")
  private String treeLevel;

  /**
   * 是否部门  1部门 0 机构
   */
  @ApiModelProperty(value = "是否部门  1部门 0 机构")
  @TableField("is_dept")
  private String isDept;

  /**
   * 是否为租赁库 0否 1是
   */
  @ApiModelProperty(value = "是否为租赁库 0否 1是")
  @TableField("is_rent")
  private String isRent;


  /**
 * 机构名称
 */
  @ApiModelProperty(value = "机构名称")

  @TableField("org_name")
  private String orgName;
/**
 * 机构编码
 */
  @ApiModelProperty(value = "机构编码")

  @TableField("org_code")
  private String orgCode;
/**
 * 联系地址
 */
  @ApiModelProperty(value = "联系地址")

  @TableField("address")
  private String address;
/**
 * 邮政编码
 */
  @ApiModelProperty(value = "邮政编码")

  @TableField("zip_code")
  private String zipCode;
/**
 * 负责人
 */
  @ApiModelProperty(value = "负责人")

  @TableField("leader")
  private String leader;
/**
 * 电话
 */
  @ApiModelProperty(value = "电话")

  @TableField("phone_no")
  private String phoneNo;

  /**
   * 传真
   */
  @ApiModelProperty(value = "传真")

  @TableField("fax")
  private String fax;

  /**
   * 邮箱
   */
  @ApiModelProperty(value = "邮箱")

  @TableField("email")
  private String email;
  //
  // /**
  //  * 备注
  //  */
  // @ApiModelProperty(value = "备注")

  // @TableField("remarks")
  // private String remarks;

  public static final String ORG_ID ="org_id";
  public static final String PARENT_ID ="parent_id";
  public static final String PARENT_IDS ="parent_ids";
  public static final String TREE_SORT ="tree_sort";
  public static final String ORG_NAME ="org_name";
  public static final String ORG_CODE ="org_code";
  public static final String ADDRESS ="address";
  public static final String ZIP_CODE ="zip_code";
  public static final String LEADER ="leader";
  public static final String PHONE_NO ="phone_no";
  public static final String FAX ="fax";
  public static final String EMAIL ="email";
  // public static final String REMARKS ="remarks";


}
