package com.testor.module.partner.model.domain;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.tongtech.tfw.backend.common.models.supers.SuperModel;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;
import lombok.experimental.Accessors;
import lombok.experimental.SuperBuilder;


/**
 * 相关方组织机构对象 t_partner_org
 *
 * @author testor-framework
 * @date 2022-06-01 14:16:53
 */
@Data
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
@TableName("t_partner_org")
@ApiModel(value = "TPartnerOrg对象", description = "")
@SuperBuilder
@AllArgsConstructor
@NoArgsConstructor
public class TPartnerOrg extends SuperModel {
    private static final long serialVersionUID = 1L;
    /**
     * id
     */
    @ApiModelProperty(value = "id(修改必填)")
    @TableId(value = "id", type = IdType.ASSIGN_UUID)
    private String id;

    @ApiModelProperty(value = "org_id")
    @TableField(value = "org_id")
    private String orgId;

    /**
     * 单位名称
     */
    @ApiModelProperty(value = "单位名称（编辑必填）")
    @TableField("name")
    private String name;

    @ApiModelProperty(value = "社会信用编码（编辑必填）")
    @TableField("credit_code")
    private String creditCode;

    /**
     * 法定代表人
     */
    @ApiModelProperty(value = "法定代表人（编辑必填）")

    @TableField("legal_person")
    private String legalPerson;

    /**
     * 是否为黑名单（0-否，1-是）
     */
    @ApiModelProperty(value = "是否为黑名单（0-否，1-是）,默认 0")
    @TableField("is_blacklist")
    private String isBlacklist;
    /**
     * 黑名单原因
     */
    @ApiModelProperty(value = "黑名单原因")
    @TableField("blacklist_reason")
    private String blacklistReason;
    /**
     * 租户id
     */
    @ApiModelProperty(value = "租户id")
    @TableField("tenant_id")
    private String tenantId;

    /**
     * 黑名单操作单位
     */
    @ApiModelProperty(value = "黑名单操作单位")
    @TableField("is_blacklist_by")
    private String isBlacklistBy;


    public static final String ID = "id";
    public static final String NAME = "name";
    public static final String LEGAL_PERSON = "legal_person";
    public static final String RESPONSIBLE_PERSON = "responsible_person";
    public static final String PHONE = "phone";
    public static final String CONTRACT_START_DATE = "contract_start_date";
    public static final String CONTRACT_END_DATE = "contract_end_date";
    public static final String CERTIFICATE_STATUS = "certificate_status";
    public static final String IS_BLACKLIST = "is_blacklist";
    public static final String BLACKLIST_REASON = "blacklist_reason";
    public static final String CREDIT_CODE = "credit_code";
    public static final String TENANT_ID = "tenant_id";
    public static final String IS_BLACKLIST_BY = "is_blacklist_by";


}
