package com.testor.module.partner.model.excel;

import com.alibaba.excel.annotation.ExcelProperty;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import org.springframework.format.annotation.DateTimeFormat;

import java.time.LocalDate;
import java.util.Date;

/**
 * 相关方机构导出列表
 */
@Data
public class PartnerExp {

    @ApiModelProperty("序号")
    @ExcelProperty(value = {"序号"}, index = 0)
    private int serialNumber;
    /**
     * 组织机构id
     */
    @ApiModelProperty(value = "相关方单位名称")
    @ExcelProperty(value = {"相关方单位名称"}, index = 1)
    private String name;

    @ApiModelProperty(value = "统一社会信用代码")
    @ExcelProperty(value = {"统一社会信用代码"}, index = 2)
    private String creditCode;

    /**
     * 类型id
     */
    @ApiModelProperty(value = "相关方类型")
    @ExcelProperty(value = {"相关方类型"}, index = 3)
    private String typeName;

    /**
     * 法定代表人
     */
    @ApiModelProperty(value = "法定代表人")
    @ExcelProperty(value = {"法定代表人"}, index = 4)
    private String legalPerson;
    /**
     * 现场负责人
     */
    @ApiModelProperty(value = "现场负责人")
    @ExcelProperty(value = {"现场负责人"}, index = 5)
    private String responsiblePerson;
    /**
     * 联系方式
     */
    @ApiModelProperty(value = "现场负责人联系方式")
    @ExcelProperty(value = {"现场负责人联系方式"}, index = 6)
    private String phone;

    /**
     * 合同日期
     */
    @ApiModelProperty(value = "合同日期开始日期")
    @ExcelProperty(value = {"合同日期开始日期"}, index = 7)
    @JsonFormat(pattern = "yyyy-MM-dd")
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    private Date contractStartDate;
    /**
     * 合同日期
     */
    @ApiModelProperty(value = "合同日期结束日期")
    @ExcelProperty(value = {"合同日期结束日期"}, index = 8)
    @JsonFormat(pattern = "yyyy-MM-dd")
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    private Date contractEndDate;

    @ApiModelProperty(value = "资质名称")
    @ExcelProperty(value = {"资质名称"}, index = 9)
    private String certificateName;

    @ApiModelProperty(value = "有效期至")
    @ExcelProperty(value = {"有效期至"}, index = 10)
    @JsonFormat(pattern = "yyyy-MM-dd")
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    private Date certificateValidEndDate;
}
