package com.testor.module.partner.model.vo;

import com.tongtech.tfw.backend.common.models.supers.SuperModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;


/**
 * 相关方组织机构对象 t_partner_org
 *
 * @author testor-framework
 * @date 2022-06-01 14:16:53
 */
@Data
public class PartnerOrgVO extends SuperModel {
    /**
     * 负责绑定id
     */
    @ApiModelProperty(value = "负责绑定id")
    private String resId;

    /**
     * 相关方id
     */
    @ApiModelProperty(value = "相关方id")
    private String partnerId;

    /**
     * 组织机构id
     */
    @ApiModelProperty(value = "系统组织机构名称")
    private String orgName;

    @ApiModelProperty(value = "类型")
    private String typeName;

    /**
     * 单位名称
     */
    @ApiModelProperty(value = "相关方单位名称")
    private String partnerName;


    /**
     * 法定代表人
     */
    @ApiModelProperty(value = "法定代表人")
    private String legalPerson;

    /**
     * 现场负责人
     */
    @ApiModelProperty(value = "现场负责人")
    private String responsiblePerson;

    /**
     * 联系方式
     */
    @ApiModelProperty(value = "联系方式")
    private String phone;


    /**
     * 资质状态（0-异常，1-正常）
     */
    @ApiModelProperty(value = "资质状态（0-异常，1-正常）,默认1", example = "1")
    private Integer certificateStatus;
    /**
     * 是否为黑名单（0-否，1-是）
     */
    @ApiModelProperty(value = "是否为黑名单（0-否，1-是）,默认 0")
    private String isBlacklist;

}
