package com.testor.module.partner.service;


import com.testor.module.partner.model.domain.TPartnerCertificate;
import com.testor.module.partner.model.dto.TPartnerCertificateDTO;
import com.tongtech.tfw.backend.common.models.supers.SuperService;

import javax.xml.crypto.Data;
import java.time.LocalDate;
import java.util.Date;
import java.util.List;

/**
 * 相关方资质证书Service接口
 *
 * @author testor-framework
 * @date 2022-06-01 14:12:52
 */
public interface TPartnerCertificateService extends SuperService<TPartnerCertificate> {
    /**
     * 检测证书有效性
     *
     * @param dateTime
     * @return false- 未失效； true-失效
     */
    boolean checkValidity(Date dateTime);

    /**
     * 资质证书与业务id进行绑定
     *
     * @param bizId 业务id
     * @param ids   资质证书id
     */
    boolean bindBizId(String bizId, List<String> ids);

    /**
     * 检测 相关方机构/人员 证书 有效性
     *
     * @return false-异常   true- 正常
     */
    boolean checkCertificateValidity(String bizId, List<String> certificateIds);

    /**
     * 定时任务： 每天检测证书是否过期
     */
    void handleValidity();

    /**
     * 编辑相关方资质
     *
     * @param addRequest 相关方资质信息
     * @return TPartnerCertificate
     */
    TPartnerCertificate editCertificate(TPartnerCertificateDTO addRequest);
}
