package com.testor.module.regime.model.domain;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.tongtech.tfw.backend.common.models.supers.SuperModel;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;
import lombok.experimental.Accessors;
import lombok.experimental.SuperBuilder;

import java.math.BigDecimal;


/**
 * 制度资料管理对象 t_regime_data
 *
 * @author testor-framework
 * @date 2022-07-01 14:14:14
 */
@Data
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
@TableName("t_regime_data")
@ApiModel(value = "TRegimeData对象", description = "")
@SuperBuilder
@AllArgsConstructor
@NoArgsConstructor
public class TRegimeData extends SuperModel {
    private static final long serialVersionUID = 1L;
    /**
     * 主键ID
     */
    @ApiModelProperty(value = "主键ID")

    @TableId("id")
    private String id;
    /**
     * 附件上传
     */
    @ApiModelProperty(value = "附件上传")

    @TableField("ref_id")
    private String refId;
    /**
     * 父级ID
     */
    @ApiModelProperty(value = "父级ID")

    @TableField("parent_id")
    private String parentId;
    /**
     * 租户id
     */
    @ApiModelProperty(value = "租户id")

    @TableField("tenant_id")
    private String tenantId;
    /**
     * 流程实例ID
     */
    @ApiModelProperty(value = "流程实例ID")

    @TableField("process_id")
    private String processId;
    /**
     * 流程状态
     */
    @ApiModelProperty(value = "流程状态")

    @TableField("process_status")
    private String processStatus;
    /**
     * 组织结构id
     */
    @ApiModelProperty(value = "组织机构id")

    @TableField("org_id")
    private String orgId;
    /**
     * 发布单位
     */
    @ApiModelProperty(value = "发布单位")

    @TableField("release_unit")
    private String releaseUnit;
    /**
     * 发布单位id
     */
    @TableField("release_unit_id")
    private String releaseUnitId;
    /**
     * 更新单位
     */
    @ApiModelProperty(value = "更新单位")
    @TableField("update_unit")
    private String updateUnit;
    /**
     * 单位层级
     */
    @ApiModelProperty(value = "单位层级")

    @TableField("\"level\"")
    private BigDecimal level;
    /**
     * 材料名称
     */
    @ApiModelProperty(value = "材料名称")

    @TableField("materials_name")
    private String materialsName;
    /**
     * 一级材料类型
     */
    @ApiModelProperty(value = "一级材料类型")

    @TableField("one_materials_type")
    private String oneMaterialsType;
    /**
     * 二级材料类型
     */
    @ApiModelProperty(value = "二级材料类型")

    @TableField("sen_materials_type")
    private String senMaterialsType;



    @ApiModelProperty(value = "材料类型")
    @TableField("regime_data_type")
    private String regimeDataType;


    public static final String ID = "id";
    public static final String REF_ID = "ref_id";
    public static final String PARENT_ID = "parent_id";
    public static final String TENANT_ID = "tenant_id";
    public static final String PROCESS_ID = "process_id";
    public static final String PROCESS_STATUS = "process_status";
    public static final String RELEASE_UNIT = "release_unit";
    public static final String LEVEL = "\"level\"";
    public static final String MATERIALS_NAME = "materials_name";
    public static final String ONE_MATERIALS_TYPE = "one_materials_type";
    public static final String SEN_MATERIALS_TYPE = "sen_materials_type";
    public static final String ORG_ID = "org_id";
    public static final String RELEASE_UNIT_ID = "release_unit_id";
    public static final String REGIME_DATA_TYPE = "regime_data_type";

}
