package com.testor.module.safe.model.domain;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.tongtech.tfw.backend.common.models.supers.SuperModel;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;
import lombok.experimental.Accessors;
import lombok.experimental.SuperBuilder;


/**
 * 隐患巡检排查标准细则对象 t_safe_hazard_option
 *
 * @author testor-framework
 * @date 2022-07-27 14:48:44
 */
@Data
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
@TableName("t_safe_hazard_option")
@ApiModel(value = "TSafeHazardOption对象", description = "")
@SuperBuilder
@AllArgsConstructor
@NoArgsConstructor
public class TSafeHazardOption extends SuperModel {
    private static final long serialVersionUID = 1L;
    /**
     * 主键ID
     */
    @ApiModelProperty(value = "主键ID")

    @TableId("id")
    private String id;
    /**
     * 附件上传
     */
    @ApiModelProperty(value = "附件上传")

    @TableField("ref_id")
    private String refId;
    /**
     * 父级ID
     */
    @ApiModelProperty(value = "父级ID")

    @TableField("parent_id")
    private String parentId;
    /**
     * 租户id
     */
    @ApiModelProperty(value = "租户id")

    @TableField("tenant_id")
    private String tenantId;
    /**
     * 流程实例ID
     */
    @ApiModelProperty(value = "流程实例ID")

    @TableField("process_id")
    private String processId;
    /**
     * 流程状态
     */
    @ApiModelProperty(value = "流程状态")

    @TableField("process_status")
    private String processStatus;
    /**
     * 检查项名称
     */
    @ApiModelProperty(value = "检查项名称")

    @TableField("check_name")
    private String checkName;
    /**
     * 检查项类别（1-大类；2-小类）
     */
    @ApiModelProperty(value = "检查项类别（1-大类；2-小类）")

    @TableField("check_type")
    private String checkType;
    /**
     * 检查项细则id（小类时有值）
     */
    @ApiModelProperty(value = "检查项细则id（小类时有值）")

    @TableField("check_id")
    private String checkId;
    /**
     * 检查细则内容
     */
    @ApiModelProperty(value = "检查细则内容")

    @TableField("check_content")
    private String checkContent;
    /**
     * 检查方法
     */
    @ApiModelProperty(value = "检查方法")

    @TableField("check_method")
    private String checkMethod;

    public static final String ID = "id";
    public static final String REF_ID = "ref_id";
    public static final String PARENT_ID = "parent_id";
    public static final String TENANT_ID = "tenant_id";
    public static final String PROCESS_ID = "process_id";
    public static final String PROCESS_STATUS = "process_status";
    public static final String CHECK_NAME = "check_name";
    public static final String CHECK_TYPE = "check_type";
    public static final String CHECK_ID = "check_id";
    public static final String CHECK_CONTENT = "check_content";
    public static final String CHECK_METHOD = "check_method";


}
