package com.testor.module.safe.model.vo;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;


/**
 * 隐患上报台账对象 t_safe_hazard_org
 *
 * @author testor-framework
 * @date 2022-08-04 14:01:01
 */
@Data
@ApiModel(value = "TSafeHazardOrgStatisticsVO 对象", description = "")
public class TSafeHazardOrgStatisticsVO {
    private static final long serialVersionUID = 1L;

    @ApiModelProperty(value = "组织机构id")
    private String orgId;

    @ApiModelProperty(value = "组织机构名称")
    private String orgName;

    @ApiModelProperty
    private Long hiddenDangersCount;

    @ApiModelProperty(value = "完成数量")
    private Long finishCount;

    @ApiModelProperty(value = "一般不符合项 - 完成")
    private Integer generallyFinish;

    @ApiModelProperty(value = "一般不符合项 - 未完成")
    private Integer generallyUndone;

    @ApiModelProperty(value = "重大不符合项 - 完成")
    private Integer majorFinish;

    @ApiModelProperty(value = "重大不符合项 - 未完成")
    private Integer majorUndone;

}
