package com.testor.module.safeCheck.controller;

import java.util.ArrayList;
import java.util.List;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import lombok.extern.slf4j.Slf4j;
import com.tongtech.tfw.backend.core.helper.StringHelper;
import com.tongtech.tfw.backend.core.helper.ObjectHelper;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RestController;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.tongtech.tfw.backend.common.biz.constants.BizConstants;
import com.tongtech.tfw.backend.common.biz.models.BaseResponse;
import com.tongtech.tfw.backend.common.biz.models.BaseResponseList;
import com.tongtech.tfw.backend.common.biz.models.BizGeneralResponse;
import com.tongtech.tfw.backend.common.models.supers.SuperController;
import com.tongtech.tfw.backend.core.helper.IdHelper;
import com.tongtech.tfw.backend.core.helper.TypeHelper;
import com.tongtech.tfw.backend.core.helper.bean.BeanHelper;

import com.testor.module.safeCheck.model.domain.TSafeCheckOrg;
import com.testor.module.safeCheck.model.dto.TSafeCheckOrgParam;
import com.testor.module.safeCheck.model.dto.TSafeCheckOrgDelParam;
import com.testor.module.safeCheck.service.TSafeCheckOrgService;

/**
 * 安全检查计划和被检查机构关系Controller
 *
 * @author rsq
 * @date 2024-09-03 08:04:16
 */
@RestController
@RequestMapping("/safeCheck/safeCheck")
@Api(value = "TSafeCheckOrg", tags = "安全检查计划和被检查机构关系")
@Slf4j
public class TSafeCheckOrgController extends SuperController
{
    @Autowired
    private TSafeCheckOrgService tSafeCheckOrgService;

    /* Generated Method*/
	@ApiOperation(value = "新增 安全检查计划和被检查机构关系", notes = "Add TSafeCheckOrg")
	@PostMapping(value = "/add")
	public BaseResponse<TSafeCheckOrg>addEntity(@RequestBody TSafeCheckOrg addRequest) {
		BaseResponse<TSafeCheckOrg> baseResponse=new BaseResponse<>();
		if(ObjectHelper.isNotEmpty(addRequest)){
			// TODO 按需求添加数据去重，特殊值设定，业务异常
			String id = IdHelper.getId32bit();
            TSafeCheckOrg data=BeanHelper.beanToBean(addRequest,  TSafeCheckOrg.class);
			data.setId(id);
			boolean result= tSafeCheckOrgService.save(data);
			if(result){
                TSafeCheckOrg newEntity = new TSafeCheckOrg();
				newEntity.setId(id);
				baseResponse.setData(newEntity);
			}
		}
		return baseResponse;
	}

	@ApiOperation(value = "获取 安全检查计划和被检查机构关系 ", notes = "Get TSafeCheckOrg By Id")
	@GetMapping(value = "/get")
	public BaseResponse<TSafeCheckOrg> getById(String id){
		BaseResponse<TSafeCheckOrg> baseResponse=new BaseResponse<>();
		if(StringHelper.isNotEmpty(id)){
			// TODO 按需求添加业务异常判断
            TSafeCheckOrg data= tSafeCheckOrgService.getById(id);
			baseResponse.setData(data);
		}
		return baseResponse;
	}

	@ApiOperation(value = "修改 安全检查计划和被检查机构关系 ", notes = "Update TSafeCheckOrg By Id")
	@PutMapping(value = "/update")
	public BaseResponse<BizGeneralResponse> updateEntity(@RequestBody TSafeCheckOrg updateRequest){
		BaseResponse<BizGeneralResponse> baseResponse=new BaseResponse<>();
		if(ObjectHelper.isNotEmpty(updateRequest)&&StringHelper.isNotEmpty(updateRequest.getId())){
			// TODO 按需求添加数据去重，特殊值设定，业务异常
            TSafeCheckOrg data=BeanHelper.beanToBean(updateRequest, TSafeCheckOrg.class);
			boolean result= tSafeCheckOrgService.updateById(data);
			baseResponse.setData(
					BizGeneralResponse.builder().result(TypeHelper.castToString(result)).build());
		}
		return baseResponse;
	}

	@ApiOperation(value = "删除 安全检查计划和被检查机构关系 ", notes = "delete TSafeCheckOrg By Id")
	@PutMapping(value = "/delete")
	public BaseResponse<BizGeneralResponse> deleteEntity(@RequestBody TSafeCheckOrgDelParam deleteRequest){
		BaseResponse<BizGeneralResponse> baseResponse=new BaseResponse<>();
		if(ObjectHelper.isNotEmpty(deleteRequest)&&StringHelper.isNotEmpty(deleteRequest.getId())){
			// TODO 按需求添加数据去重，特殊值设定，业务异常
            TSafeCheckOrg data= new TSafeCheckOrg();
			data.setId(deleteRequest.getId());
			data.setStatus(BizConstants.STATUS_DELETE);
			boolean result= tSafeCheckOrgService.updateById(data);
			baseResponse.setData(
					BizGeneralResponse.builder().result(TypeHelper.castToString(result)).build());
		}
		return baseResponse;
	}

	@ApiOperation(value = "批量删除安全检查计划和被检查机构关系", notes = "delete TSafeCheckOrg by batch Id")
	@PutMapping(value = "/batch_delete")
	public BaseResponse<BizGeneralResponse> deleteEntityBatch(
			@RequestBody TSafeCheckOrgDelParam deleteRequest) {
		BaseResponse<BizGeneralResponse> baseResponse = new BaseResponse<>();
		if (ObjectHelper.isNotEmpty(deleteRequest) && (!deleteRequest.getIds().isEmpty())) {
            /* 批量删除 */
			List<TSafeCheckOrg> tSafeCheckOrgList = new ArrayList<>();
            for(String id: deleteRequest.getIds()){
                TSafeCheckOrg data= new TSafeCheckOrg();
				data.setId(id);
				data.setStatus(BizConstants.STATUS_DELETE);
                tSafeCheckOrgList.add(data);
			}
			boolean result = tSafeCheckOrgService.updateBatchById(tSafeCheckOrgList);
			baseResponse.setData(
					BizGeneralResponse.builder().result(TypeHelper.castToString(result)).build());
		}
		return baseResponse;
	}

	@ApiOperation(value = "获取 安全检查计划和被检查机构关系 分页列表", notes = "List TSafeCheckOrg with page")
	@GetMapping(value = "/list")
	public  BaseResponse<BaseResponseList<TSafeCheckOrg>>listEntity(TSafeCheckOrgParam param){
		BaseResponse<BaseResponseList<TSafeCheckOrg>>baseResponse=new BaseResponse<>();
		Long page=
				StringHelper.isEmpty(param.getPage())?BizConstants.PAGE:Long.valueOf(param.getPage());
		Long limit=
				StringHelper.isEmpty(param.getLimit())?BizConstants.LIMIT:Long.valueOf(param.getLimit());
		Page<TSafeCheckOrg> resultPage=new Page<>(page,limit);
		// TODO 根据需求修改查询条件及查询参数
		QueryWrapper<TSafeCheckOrg> queryWrapper=this.createQuery(param);
		Page<TSafeCheckOrg> resultList= tSafeCheckOrgService.page(resultPage,queryWrapper);
		BaseResponseList<TSafeCheckOrg> baseResponseList=new BaseResponseList<>();
		baseResponseList.setData(resultList.getRecords());
		baseResponseList.setTotal(resultList.getTotal());
		baseResponse.setData(baseResponseList);
		return baseResponse;
	}

	@ApiOperation(value = "获取 安全检查计划和被检查机构关系 列表", notes = "List TSafeCheckOrg all")
	@GetMapping(value = "/datas")
	public  BaseResponse<BaseResponseList<TSafeCheckOrg>>listAllEntity(TSafeCheckOrgParam param){
		BaseResponse<BaseResponseList<TSafeCheckOrg>>baseResponse=new BaseResponse<>();
		// TODO 根据需求修改查询条件及查询参数
		QueryWrapper<TSafeCheckOrg> queryWrapper=this.createQuery(param);
		List<TSafeCheckOrg> resultList=tSafeCheckOrgService.list(queryWrapper);
		BaseResponseList<TSafeCheckOrg> baseResponseList=new BaseResponseList<>();
		baseResponseList.setData(resultList);
		baseResponseList.setTotal(resultList.size());
		baseResponse.setData(baseResponseList);
		return baseResponse;
	}

    /* Private Methods */
	/**
     * 列表查询条件及查询参数
     */
	private QueryWrapper<TSafeCheckOrg> createQuery(TSafeCheckOrgParam queryParam){
		QueryWrapper<TSafeCheckOrg> queryWrapper=new QueryWrapper<>();
		if(StringHelper.isNotEmpty(queryParam.getPlanId())){
			queryWrapper.eq(TSafeCheckOrg.PLAN_ID,queryParam.getPlanId());
		}
		if(StringHelper.isNotEmpty(queryParam.getCheckOrgId())){
			queryWrapper.eq(TSafeCheckOrg.CHECK_ORG_ID,queryParam.getCheckOrgId());
		}
		if (StringHelper.isNotEmpty(queryParam.getStatus())) {
			queryWrapper.eq(TSafeCheckOrg.STATUS, queryParam.getStatus());
		} else {
			queryWrapper.ne(TSafeCheckOrg.STATUS, BizConstants.STATUS_DELETE);
		}
		if (StringHelper.isNotEmpty(queryParam.getOrderBy())){
			if(StringHelper.isNotEmpty(queryParam.getOrderType())
					&&BizConstants.ASC.equals(queryParam.getOrderType())){
				queryWrapper.orderByAsc(queryParam.getOrderBy());
			}else{
				queryWrapper.orderByDesc(queryParam.getOrderBy());
			}
		}else{
			queryWrapper.orderByDesc(TSafeCheckOrg.UPDATE_DATE);
		}
		return queryWrapper;
	}
}
