package com.testor.module.safeCheck.controller;

import com.testor.module.safeCheck.model.domain.TSafeHazardCheckDelay;
import com.testor.module.safeCheck.model.dto.TSafeHazardCheckDelayDelParam;
import com.testor.module.safeCheck.model.vo.SafeHazardCheckTaskDelayVO;
import com.testor.module.safeCheck.service.TSafeHazardCheckDelayService;
import com.tongtech.tfw.backend.common.biz.models.BaseResponse;
import com.tongtech.tfw.backend.common.biz.models.BaseResponseList;
import com.tongtech.tfw.backend.common.models.supers.SuperController;
import com.tongtech.tfw.backend.core.helper.StringHelper;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.util.List;

/**
 * 巡检任务延期申请Controller
 *
 * @author testor-framework
 * @date 2022-08-04 11:07:09
 */
@RestController
@RequestMapping("/safeCheck/checkDelay")
@Api(value = "TSafeHazardCheckDelay", tags = "巡检任务延期申请")
@Slf4j
public class TSafeHazardCheckDelayController extends SuperController
{
    @Autowired
    private TSafeHazardCheckDelayService tSafeHazardCheckDelayService;


	/* Generated Method*/
	@ApiOperation(value = "新增、修改 巡检任务延期申请", notes = "Add TSafeHazardCheckPlan")
	@PostMapping(value = "/edit")
	public BaseResponse<TSafeHazardCheckDelay> addEntity(@RequestBody TSafeHazardCheckDelay addRequest) {
		return tSafeHazardCheckDelayService.editCheckDelay(addRequest);
	}

	/* Generated Method*/
	@ApiOperation(value = "审批 巡检任务延期申请", notes = "Add TSafeHazardCheckPlan")
	@PostMapping(value = "/approval")
	public BaseResponse<TSafeHazardCheckDelay> approvalEntity(@RequestBody TSafeHazardCheckDelay addRequest) {
		return tSafeHazardCheckDelayService.approvalCheckDelay(addRequest);
	}

	@ApiOperation(value = "根据任务获取 巡检任务延期申请 列表", notes = "List TSafeHazardCheckDelay all")
	@GetMapping(value = "/listByTask")
	public  BaseResponse<BaseResponseList<TSafeHazardCheckDelay>>listByTask(@RequestParam("taskId") String taskId){
		BaseResponse<BaseResponseList<TSafeHazardCheckDelay>>baseResponse=new BaseResponse<>();
		List<TSafeHazardCheckDelay> resultList=tSafeHazardCheckDelayService.listByTask(taskId);
		BaseResponseList<TSafeHazardCheckDelay> baseResponseList=new BaseResponseList<>();
		baseResponseList.setData(resultList);
		baseResponseList.setTotal(resultList.size());
		baseResponse.setData(baseResponseList);
		return baseResponse;
	}

	@ApiOperation(value = "获取 巡检任务延期申请 ", notes = "Get TSafeHazardCheckDelay By Id")
	@GetMapping(value = "/get")
	public BaseResponse<SafeHazardCheckTaskDelayVO> getById(String id){
		BaseResponse<SafeHazardCheckTaskDelayVO> baseResponse=new BaseResponse<>();
		if(StringHelper.isNotEmpty(id)){
			// TODO 按需求添加业务异常判断
            SafeHazardCheckTaskDelayVO data= tSafeHazardCheckDelayService.findById(id);
			baseResponse.setData(data);
		}
		return baseResponse;
	}

	@ApiOperation(value = "删除 巡检任务延期申请 ", notes = "delete TSafeHazardCheckDelay By Id")
	@PutMapping(value = "/delete")
	public BaseResponse deleteEntity(@RequestBody TSafeHazardCheckDelayDelParam deleteRequest){
		BaseResponse baseResponse= tSafeHazardCheckDelayService.deleteCheckDelay(deleteRequest.getId());
		return baseResponse;
	}

//	@ApiOperation(value = "批量删除巡检任务延期申请", notes = "delete TSafeHazardCheckDelay by batch Id")
//	@PutMapping(value = "/batch_delete")
//	public BaseResponse<BizGeneralResponse> deleteEntityBatch(
//			@RequestBody TSafeHazardCheckDelayDelParam deleteRequest) {
//		BaseResponse<BizGeneralResponse> baseResponse = new BaseResponse<>();
//		if (ObjectHelper.isNotEmpty(deleteRequest) && (!deleteRequest.getIds().isEmpty())) {
//            /* 批量删除 */
//			List<TSafeHazardCheckDelay> tSafeHazardCheckDelayList = new ArrayList<>();
//            for(String id: deleteRequest.getIds()){
//                TSafeHazardCheckDelay data= new TSafeHazardCheckDelay();
//				data.setId(id);
//				data.setStatus(BizConstants.STATUS_DELETE);
//                tSafeHazardCheckDelayList.add(data);
//			}
//			boolean result = tSafeHazardCheckDelayService.updateBatchById(tSafeHazardCheckDelayList);
//			baseResponse.setData(
//					BizGeneralResponse.builder().result(TypeHelper.castToString(result)).build());
//		}
//		return baseResponse;
//	}

//	@ApiOperation(value = "获取 巡检任务延期申请 分页列表", notes = "List TSafeHazardCheckDelay with page")
//	@GetMapping(value = "/list")
//	public  BaseResponse<BaseResponseList<TSafeHazardCheckDelay>>listEntity(TSafeHazardCheckDelayParam param){
//		BaseResponse<BaseResponseList<TSafeHazardCheckDelay>>baseResponse=new BaseResponse<>();
//		Long page=
//				StringHelper.isEmpty(param.getPage())?BizConstants.PAGE:Long.valueOf(param.getPage());
//		Long limit=
//				StringHelper.isEmpty(param.getLimit())?BizConstants.LIMIT:Long.valueOf(param.getLimit());
//		Page<TSafeHazardCheckDelay> resultPage=new Page<>(page,limit);
//		// TODO 根据需求修改查询条件及查询参数
//		QueryWrapper<TSafeHazardCheckDelay> queryWrapper=this.createQuery(param);
//		Page<TSafeHazardCheckDelay> resultList= tSafeHazardCheckDelayService.page(resultPage,queryWrapper);
//		BaseResponseList<TSafeHazardCheckDelay> baseResponseList=new BaseResponseList<>();
//		baseResponseList.setData(resultList.getRecords());
//		baseResponseList.setTotal(resultList.getTotal());
//		baseResponse.setData(baseResponseList);
//		return baseResponse;
//	}

//	@ApiOperation(value = "获取 巡检任务延期申请 列表", notes = "List TSafeHazardCheckDelay all")
//	@GetMapping(value = "/datas")
//	public  BaseResponse<BaseResponseList<TSafeHazardCheckDelay>>listAllEntity(TSafeHazardCheckDelayParam param){
//		BaseResponse<BaseResponseList<TSafeHazardCheckDelay>>baseResponse=new BaseResponse<>();
//		// TODO 根据需求修改查询条件及查询参数
//		QueryWrapper<TSafeHazardCheckDelay> queryWrapper=this.createQuery(param);
//		List<TSafeHazardCheckDelay> resultList=tSafeHazardCheckDelayService.list(queryWrapper);
//		BaseResponseList<TSafeHazardCheckDelay> baseResponseList=new BaseResponseList<>();
//		baseResponseList.setData(resultList);
//		baseResponseList.setTotal(resultList.size());
//		baseResponse.setData(baseResponseList);
//		return baseResponse;
//	}


}
