package com.testor.module.safeCheck.controller;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.testor.module.safeCheck.model.domain.TSafeHazardCheckObject;
import com.testor.module.safeCheck.model.dto.TSafeHazardCheckObjectParam;
import com.testor.module.safeCheck.service.TSafeHazardCheckObjectService;
import com.tongtech.tfw.backend.common.biz.constants.BizConstants;
import com.tongtech.tfw.backend.common.models.supers.SuperController;
import com.tongtech.tfw.backend.core.helper.StringHelper;
import io.swagger.annotations.Api;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

/**
 * 巡检对象Controller
 *
 * @author testor-framework
 * @date 2022-08-04 11:07:48
 */
@RestController
@RequestMapping("/safeCheck/checkObject")
@Api(value = "TSafeHazardCheckObject", tags = "巡检对象")
@Slf4j
public class TSafeHazardCheckObjectController extends SuperController
{
    @Autowired
    private TSafeHazardCheckObjectService tSafeHazardCheckObjectService;

//    /* Generated Method*/
//	@ApiOperation(value = "新增、修改 巡检对象", notes = "Add TSafeHazardCheckObject")
//	@PostMapping(value = "/edit")
//	public BaseResponse<TSafeHazardCheckObject>addEntity(@RequestBody TSafeHazardCheckObject addRequest) {
//		BaseResponse<TSafeHazardCheckObject> baseResponse=new BaseResponse<>();
//		baseResponse = tSafeHazardCheckObjectService.editCheckObject(addRequest);
//		return baseResponse;
//	}

//	@ApiOperation(value = "获取 巡检对象 ", notes = "Get TSafeHazardCheckObject By Id")
//	@GetMapping(value = "/get")
//	public BaseResponse<TSafeHazardCheckObject> getById(String id){
//		BaseResponse<TSafeHazardCheckObject> baseResponse=new BaseResponse<>();
//		if(StringHelper.isNotEmpty(id)){
//            TSafeHazardCheckObject data= tSafeHazardCheckObjectService.getById(id);
//			baseResponse.setData(data);
//		}
//		return baseResponse;
//	}
//
//	@ApiOperation(value = "删除 巡检对象 ", notes = "delete TSafeHazardCheckObject By Id")
//	@PutMapping(value = "/delete")
//	public BaseResponse<BizGeneralResponse> deleteEntity(@RequestBody TSafeHazardCheckObjectDelParam deleteRequest){
//		BaseResponse<BizGeneralResponse> baseResponse=new BaseResponse<>();
//		if(ObjectHelper.isNotEmpty(deleteRequest)&&StringHelper.isNotEmpty(deleteRequest.getId())){
//            TSafeHazardCheckObject data= new TSafeHazardCheckObject();
//			data.setId(deleteRequest.getId());
//			data.setStatus(BizConstants.STATUS_DELETE);
//			boolean result= tSafeHazardCheckObjectService.updateById(data);
//			baseResponse.setData(
//					BizGeneralResponse.builder().result(TypeHelper.castToString(result)).build());
//		}
//		return baseResponse;
//	}
//
//	@ApiOperation(value = "批量删除巡检对象", notes = "delete TSafeHazardCheckObject by batch Id")
//	@PutMapping(value = "/batch_delete")
//	public BaseResponse<BizGeneralResponse> deleteEntityBatch(
//			@RequestBody TSafeHazardCheckObjectDelParam deleteRequest) {
//		BaseResponse<BizGeneralResponse> baseResponse = new BaseResponse<>();
//		if (ObjectHelper.isNotEmpty(deleteRequest) && (!deleteRequest.getIds().isEmpty())) {
//            /* 批量删除 */
//			List<TSafeHazardCheckObject> tSafeHazardCheckObjectList = new ArrayList<>();
//            for(String id: deleteRequest.getIds()){
//                TSafeHazardCheckObject data= new TSafeHazardCheckObject();
//				data.setId(id);
//				data.setStatus(BizConstants.STATUS_DELETE);
//                tSafeHazardCheckObjectList.add(data);
//			}
//			boolean result = tSafeHazardCheckObjectService.updateBatchById(tSafeHazardCheckObjectList);
//			baseResponse.setData(
//					BizGeneralResponse.builder().result(TypeHelper.castToString(result)).build());
//		}
//		return baseResponse;
//	}
//
//	@ApiOperation(value = "获取 巡检对象 分页列表", notes = "List TSafeHazardCheckObject with page")
//	@GetMapping(value = "/list")
//	public  BaseResponse<BaseResponseList<TSafeHazardCheckObject>>listEntity(TSafeHazardCheckObjectParam param){
//		BaseResponse<BaseResponseList<TSafeHazardCheckObject>>baseResponse=new BaseResponse<>();
//		Long page=
//				StringHelper.isEmpty(param.getPage())?BizConstants.PAGE:Long.valueOf(param.getPage());
//		Long limit=
//				StringHelper.isEmpty(param.getLimit())?BizConstants.LIMIT:Long.valueOf(param.getLimit());
//		Page<TSafeHazardCheckObject> resultPage=new Page<>(page,limit);
//		// TODO 根据需求修改查询条件及查询参数
//		QueryWrapper<TSafeHazardCheckObject> queryWrapper=this.createQuery(param);
//		Page<TSafeHazardCheckObject> resultList= tSafeHazardCheckObjectService.page(resultPage,queryWrapper);
//		BaseResponseList<TSafeHazardCheckObject> baseResponseList=new BaseResponseList<>();
//		baseResponseList.setData(resultList.getRecords());
//		baseResponseList.setTotal(resultList.getTotal());
//		baseResponse.setData(baseResponseList);
//		return baseResponse;
//	}
//
//	@ApiOperation(value = "获取 巡检对象 列表", notes = "List TSafeHazardCheckObject all")
//	@GetMapping(value = "/datas")
//	public  BaseResponse<BaseResponseList<TSafeHazardCheckObject>>listAllEntity(TSafeHazardCheckObjectParam param){
//		BaseResponse<BaseResponseList<TSafeHazardCheckObject>>baseResponse=new BaseResponse<>();
//		// TODO 根据需求修改查询条件及查询参数
//		QueryWrapper<TSafeHazardCheckObject> queryWrapper=this.createQuery(param);
//		List<TSafeHazardCheckObject> resultList=tSafeHazardCheckObjectService.list(queryWrapper);
//		BaseResponseList<TSafeHazardCheckObject> baseResponseList=new BaseResponseList<>();
//		baseResponseList.setData(resultList);
//		baseResponseList.setTotal(resultList.size());
//		baseResponse.setData(baseResponseList);
//		return baseResponse;
//	}

    /* Private Methods */
	/**
     * 列表查询条件及查询参数
     */
	private QueryWrapper<TSafeHazardCheckObject> createQuery(TSafeHazardCheckObjectParam queryParam){
		QueryWrapper<TSafeHazardCheckObject> queryWrapper=new QueryWrapper<>();
		if(StringHelper.isNotEmpty(queryParam.getPlanId())){
			queryWrapper.eq(TSafeHazardCheckObject.PLAN_ID,queryParam.getPlanId());
		}
		if(StringHelper.isNotEmpty(queryParam.getObjTypeId())){
			queryWrapper.eq(TSafeHazardCheckObject.OBJ_TYPE_ID,queryParam.getObjTypeId());
		}
		if(StringHelper.isNotEmpty(queryParam.getObjId())){
			queryWrapper.eq(TSafeHazardCheckObject.OBJ_ID,queryParam.getObjId());
		}
		if(StringHelper.isNotEmpty(queryParam.getStandardId())){
			queryWrapper.eq(TSafeHazardCheckObject.STANDARD_ID,queryParam.getStandardId());
		}
		if (StringHelper.isNotEmpty(queryParam.getStatus())) {
			queryWrapper.eq(TSafeHazardCheckObject.STATUS, queryParam.getStatus());
		} else {
			queryWrapper.ne(TSafeHazardCheckObject.STATUS, BizConstants.STATUS_DELETE);
		}
		if (StringHelper.isNotEmpty(queryParam.getOrderBy())){
			if(StringHelper.isNotEmpty(queryParam.getOrderType())
					&&BizConstants.ASC.equals(queryParam.getOrderType())){
				queryWrapper.orderByAsc(queryParam.getOrderBy());
			}else{
				queryWrapper.orderByDesc(queryParam.getOrderBy());
			}
		}else{
			queryWrapper.orderByDesc(TSafeHazardCheckObject.UPDATE_DATE);
		}
		return queryWrapper;
	}
}
