package com.testor.module.safeCheck.controller;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.testor.module.safeCheck.model.domain.TSafeHazardCheckPeople;
import com.testor.module.safeCheck.model.dto.TSafeHazardCheckPeopleParam;
import com.testor.module.safeCheck.service.TSafeHazardCheckPeopleService;
import com.tongtech.tfw.backend.common.biz.constants.BizConstants;
import com.tongtech.tfw.backend.common.models.supers.SuperController;
import com.tongtech.tfw.backend.core.helper.ObjectHelper;
import com.tongtech.tfw.backend.core.helper.StringHelper;
import io.swagger.annotations.Api;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

/**
 * 巡检人员Controller
 *
 * @author testor-framework
 * @date 2022-08-04 11:07:50
 */
@RestController
@RequestMapping("/safeCheck/checkPeople")
@Api(value = "TSafeHazardCheckPeople", tags = "巡检人员")
@Slf4j
public class TSafeHazardCheckPeopleController extends SuperController
{
    @Autowired
    private TSafeHazardCheckPeopleService tSafeHazardCheckPeopleService;

//    /* Generated Method*/
//	@ApiOperation(value = "新增 巡检人员", notes = "Add TSafeHazardCheckPeople")
//	@PostMapping(value = "/add")
//	public BaseResponse<TSafeHazardCheckPeople>addEntity(@RequestBody TSafeHazardCheckPeople addRequest) {
//		BaseResponse<TSafeHazardCheckPeople> baseResponse=new BaseResponse<>();
//		if(ObjectHelper.isNotEmpty(addRequest)){
//			// TODO 按需求添加数据去重，特殊值设定，业务异常
//			String id = IdHelper.getId32bit();
//            TSafeHazardCheckPeople data=BeanHelper.beanToBean(addRequest,  TSafeHazardCheckPeople.class);
//			data.setId(id);
//			boolean result= tSafeHazardCheckPeopleService.save(data);
//			if(result){
//                TSafeHazardCheckPeople newEntity = new TSafeHazardCheckPeople();
//				newEntity.setId(id);
//				baseResponse.setData(newEntity);
//			}
//		}
//		return baseResponse;
//	}

//	@ApiOperation(value = "获取 巡检人员 ", notes = "Get TSafeHazardCheckPeople By Id")
//	@GetMapping(value = "/get")
//	public BaseResponse<TSafeHazardCheckPeople> getById(String id){
//		BaseResponse<TSafeHazardCheckPeople> baseResponse=new BaseResponse<>();
//		if(StringHelper.isNotEmpty(id)){
//			// TODO 按需求添加业务异常判断
//            TSafeHazardCheckPeople data= tSafeHazardCheckPeopleService.getById(id);
//			baseResponse.setData(data);
//		}
//		return baseResponse;
//	}

//	@ApiOperation(value = "修改 巡检人员 ", notes = "Update TSafeHazardCheckPeople By Id")
//	@PutMapping(value = "/update")
//	public BaseResponse<BizGeneralResponse> updateEntity(@RequestBody TSafeHazardCheckPeople updateRequest){
//		BaseResponse<BizGeneralResponse> baseResponse=new BaseResponse<>();
//		if(ObjectHelper.isNotEmpty(updateRequest)&&StringHelper.isNotEmpty(updateRequest.getId())){
//			// TODO 按需求添加数据去重，特殊值设定，业务异常
//            TSafeHazardCheckPeople data=BeanHelper.beanToBean(updateRequest, TSafeHazardCheckPeople.class);
//			boolean result= tSafeHazardCheckPeopleService.updateById(data);
//			baseResponse.setData(
//					BizGeneralResponse.builder().result(TypeHelper.castToString(result)).build());
//		}
//		return baseResponse;
//	}

//	@ApiOperation(value = "删除 巡检人员 ", notes = "delete TSafeHazardCheckPeople By Id")
//	@PutMapping(value = "/delete")
//	public BaseResponse<BizGeneralResponse> deleteEntity(@RequestBody TSafeHazardCheckPeopleDelParam deleteRequest){
//		BaseResponse<BizGeneralResponse> baseResponse=new BaseResponse<>();
//		if(ObjectHelper.isNotEmpty(deleteRequest)&&StringHelper.isNotEmpty(deleteRequest.getId())){
//			// TODO 按需求添加数据去重，特殊值设定，业务异常
//            TSafeHazardCheckPeople data= new TSafeHazardCheckPeople();
//			data.setId(deleteRequest.getId());
//			data.setStatus(BizConstants.STATUS_DELETE);
//			boolean result= tSafeHazardCheckPeopleService.updateById(data);
//			baseResponse.setData(
//					BizGeneralResponse.builder().result(TypeHelper.castToString(result)).build());
//		}
//		return baseResponse;
//	}

//	@ApiOperation(value = "批量删除巡检人员", notes = "delete TSafeHazardCheckPeople by batch Id")
//	@PutMapping(value = "/batch_delete")
//	public BaseResponse<BizGeneralResponse> deleteEntityBatch(
//			@RequestBody TSafeHazardCheckPeopleDelParam deleteRequest) {
//		BaseResponse<BizGeneralResponse> baseResponse = new BaseResponse<>();
//		if (ObjectHelper.isNotEmpty(deleteRequest) && (!deleteRequest.getIds().isEmpty())) {
//            /* 批量删除 */
//			List<TSafeHazardCheckPeople> tSafeHazardCheckPeopleList = new ArrayList<>();
//            for(String id: deleteRequest.getIds()){
//                TSafeHazardCheckPeople data= new TSafeHazardCheckPeople();
//				data.setId(id);
//				data.setStatus(BizConstants.STATUS_DELETE);
//                tSafeHazardCheckPeopleList.add(data);
//			}
//			boolean result = tSafeHazardCheckPeopleService.updateBatchById(tSafeHazardCheckPeopleList);
//			baseResponse.setData(
//					BizGeneralResponse.builder().result(TypeHelper.castToString(result)).build());
//		}
//		return baseResponse;
//	}

//	@ApiOperation(value = "获取 巡检人员 分页列表", notes = "List TSafeHazardCheckPeople with page")
//	@GetMapping(value = "/list")
//	public  BaseResponse<BaseResponseList<TSafeHazardCheckPeople>>listEntity(TSafeHazardCheckPeopleParam param){
//		BaseResponse<BaseResponseList<TSafeHazardCheckPeople>>baseResponse=new BaseResponse<>();
//		Long page=
//				StringHelper.isEmpty(param.getPage())?BizConstants.PAGE:Long.valueOf(param.getPage());
//		Long limit=
//				StringHelper.isEmpty(param.getLimit())?BizConstants.LIMIT:Long.valueOf(param.getLimit());
//		Page<TSafeHazardCheckPeople> resultPage=new Page<>(page,limit);
//		// TODO 根据需求修改查询条件及查询参数
//		QueryWrapper<TSafeHazardCheckPeople> queryWrapper=this.createQuery(param);
//		Page<TSafeHazardCheckPeople> resultList= tSafeHazardCheckPeopleService.page(resultPage,queryWrapper);
//		BaseResponseList<TSafeHazardCheckPeople> baseResponseList=new BaseResponseList<>();
//		baseResponseList.setData(resultList.getRecords());
//		baseResponseList.setTotal(resultList.getTotal());
//		baseResponse.setData(baseResponseList);
//		return baseResponse;
//	}

//	@ApiOperation(value = "获取 巡检人员 列表", notes = "List TSafeHazardCheckPeople all")
//	@GetMapping(value = "/datas")
//	public  BaseResponse<BaseResponseList<TSafeHazardCheckPeople>>listAllEntity(TSafeHazardCheckPeopleParam param){
//		BaseResponse<BaseResponseList<TSafeHazardCheckPeople>>baseResponse=new BaseResponse<>();
//		// TODO 根据需求修改查询条件及查询参数
//		QueryWrapper<TSafeHazardCheckPeople> queryWrapper=this.createQuery(param);
//		List<TSafeHazardCheckPeople> resultList=tSafeHazardCheckPeopleService.list(queryWrapper);
//		BaseResponseList<TSafeHazardCheckPeople> baseResponseList=new BaseResponseList<>();
//		baseResponseList.setData(resultList);
//		baseResponseList.setTotal(resultList.size());
//		baseResponse.setData(baseResponseList);
//		return baseResponse;
//	}

    /* Private Methods */
	/**
     * 列表查询条件及查询参数
     */
	private QueryWrapper<TSafeHazardCheckPeople> createQuery(TSafeHazardCheckPeopleParam queryParam){
		QueryWrapper<TSafeHazardCheckPeople> queryWrapper=new QueryWrapper<>();
		if(StringHelper.isNotEmpty(queryParam.getPlanId())){
			queryWrapper.eq(TSafeHazardCheckPeople.PLAN_ID,queryParam.getPlanId());
		}
		if(StringHelper.isNotEmpty(queryParam.getUserId())){
			queryWrapper.eq(TSafeHazardCheckPeople.USER_ID,queryParam.getUserId());
		}
		if(StringHelper.isNotEmpty(queryParam.getCheckTypeId())){
			queryWrapper.eq(TSafeHazardCheckPeople.CHECK_TYPE_ID,queryParam.getCheckTypeId());
		}
		if(StringHelper.isNotEmpty(queryParam.getFrequencyKey())){
			queryWrapper.eq(TSafeHazardCheckPeople.FREQUENCY_KEY,queryParam.getFrequencyKey());
		}
		if(ObjectHelper.isNotEmpty(queryParam.getStartTime())){
			queryWrapper.eq(TSafeHazardCheckPeople.START_TIME,queryParam.getStartTime());
		}
		if(ObjectHelper.isNotEmpty(queryParam.getStartDate())){
			queryWrapper.eq(TSafeHazardCheckPeople.START_DATE,queryParam.getStartDate());
		}
		if(ObjectHelper.isNotEmpty(queryParam.getStartDayNum())){
			queryWrapper.eq(TSafeHazardCheckPeople.START_DAY_NUM,queryParam.getStartDayNum());
		}
		if(ObjectHelper.isNotEmpty(queryParam.getStartMonthNum())){
			queryWrapper.eq(TSafeHazardCheckPeople.START_MONTH_NUM,queryParam.getStartMonthNum());
		}
		if(ObjectHelper.isNotEmpty(queryParam.getEndTime())){
			queryWrapper.eq(TSafeHazardCheckPeople.END_TIME,queryParam.getEndTime());
		}
		if(ObjectHelper.isNotEmpty(queryParam.getEndDate())){
			queryWrapper.eq(TSafeHazardCheckPeople.END_DATE,queryParam.getEndDate());
		}
		if(ObjectHelper.isNotEmpty(queryParam.getEndDayNum())){
			queryWrapper.eq(TSafeHazardCheckPeople.END_DAY_NUM,queryParam.getEndDayNum());
		}
		if(ObjectHelper.isNotEmpty(queryParam.getEndMonthNum())){
			queryWrapper.eq(TSafeHazardCheckPeople.END_MONTH_NUM,queryParam.getEndMonthNum());
		}
//		if(StringHelper.isNotEmpty(queryParam.getCronExpression())){
//			queryWrapper.eq(TSafeHazardCheckPeople.CRON_EXPRESSION,queryParam.getCronExpression());
//		}
		if (StringHelper.isNotEmpty(queryParam.getStatus())) {
			queryWrapper.eq(TSafeHazardCheckPeople.STATUS, queryParam.getStatus());
		} else {
			queryWrapper.ne(TSafeHazardCheckPeople.STATUS, BizConstants.STATUS_DELETE);
		}
		if (StringHelper.isNotEmpty(queryParam.getOrderBy())){
			if(StringHelper.isNotEmpty(queryParam.getOrderType())
					&&BizConstants.ASC.equals(queryParam.getOrderType())){
				queryWrapper.orderByAsc(queryParam.getOrderBy());
			}else{
				queryWrapper.orderByDesc(queryParam.getOrderBy());
			}
		}else{
			queryWrapper.orderByDesc(TSafeHazardCheckPeople.UPDATE_DATE);
		}
		return queryWrapper;
	}
}
