package com.testor.module.safeCheck.model.domain;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;
import lombok.experimental.Accessors;
import lombok.experimental.SuperBuilder;
import com.baomidou.mybatisplus.annotation.TableName;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableField;
import com.tongtech.tfw.backend.common.models.supers.SuperModel;

import java.util.List;


/**
 * 安全检查任务检查人员安排对象 t_safe_check_person
 *
 * @author testor-framework
 * @date 2024-09-04 02:08:47
 */
@Data
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
@TableName("t_safe_check_person")
@ApiModel(value = "TSafeCheckPerson对象" , description = "")
@SuperBuilder
@AllArgsConstructor
@NoArgsConstructor
public class TSafeCheckPerson extends SuperModel
{
  private static final long serialVersionUID = 1L;

  @TableId("id")
  private String id;
  /**
   * 安全巡检计划id
   */
  @ApiModelProperty(value = "安全巡检计划id")

  @TableField("plan_id")
  private String planId;

  /**
   * 检查人员名称
   */
  @ApiModelProperty(value = "检查人员名称")

  @TableField(exist = false)
  private String checkPersonName;

  /**
   * 检查类型(字典值)
   */
  @ApiModelProperty(value = "检查类型名称(字典值)")

  @TableField("check_type")
  private String checkType;

  /**
   * 检查类型(字典值)
   */
  @ApiModelProperty(value = "检查类型(字典值)")

  @TableField(exist = false)
  private String checkTypeName;
  /**
   * 任务频次
   */
  @ApiModelProperty(value = "任务频次")

  @TableField("frequency")
  private String frequency;

  /**
   * 时间(hh:mm:ss)
   */
  @ApiModelProperty(value = "时间(hh:mm:ss)")

  @TableField("start_time")
  private String startTime;

  /**
   * 日期(日期,不包含时间)
   */
  @ApiModelProperty(value = "日期(日期,不包含时间)")

  @TableField("start_date")
  private String startDate;
  /**
   * 数字天(如一个月的第几天(1-31,0表示最后一天)，周的周几(1-7))
   */
  @ApiModelProperty(value = "数字天(如一个月的第几天(1-31,0表示最后一天)，周的周几(1-7))" , example = "0")

  @TableField("start_day_num")
  private Integer startDayNum;
  /**
   * 数字月(如年的第几个月，季度的第几个月)
   */
  @ApiModelProperty(value = "数字月(如年的第几个月，季度的第几个月)" , example = "0")

  @TableField("start_month_num")
  private Integer startMonthNum;
  /**
   * 时间
   */
  @ApiModelProperty(value = "时间")

  @TableField("end_time")
  private String endTime;
  /**
   * 日期(日期,不包含时间)
   */
  @ApiModelProperty(value = "日期(日期,不包含时间)")

  @TableField("end_date")
  private String endDate;
  /**
   * 数字天(如一个月的第几天，周的周几)
   */
  @ApiModelProperty(value = "数字天(如一个月的第几天，周的周几)" , example = "0")

  @TableField("end_day_num")
  private Integer endDayNum;
  /**
   * 数字月(如年的第几个月，季度的第几个月)
   */
  @ApiModelProperty(value = "数字月(如年的第几个月，季度的第几个月)" , example = "0")

  @TableField("end_month_num")
  private Integer endMonthNum;
  /**
   * 开始时间cron(包括计划的提前时间)
   */
  @ApiModelProperty(value = "开始时间cron(包括计划的提前时间)")

  @TableField("start_cron_expression")
  private String startCronExpression;
  /**
   * 结束时间cron
   */
  @ApiModelProperty(value = "结束时间cron")

  @TableField("end_cron_expression")
  private String endCronExpression;
  /**
   * 是否生成任务(0-未生成，1-生成)
   */
  @ApiModelProperty(value = "是否生成任务(0-未生成，1-生成)")

  @TableField("generate_task")
  private String generateTask;

  @TableField(exist = false)
  @ApiModelProperty(value = "人员安排具体人员信息")
  private List<TSafeCheckPersonArrange> tSafeCheckPersonArranges;

  @TableField(exist = false)
  @ApiModelProperty(value = "人员安排具体人员信息")
  private String peopleName;

  public static final String ID ="id";
  public static final String PLAN_ID ="plan_id";
  public static final String CHECK_PERSON_ID ="check_person_id";
  public static final String CHECK_TYPE ="check_type";
  public static final String FREQUENCY ="frequency_key";
  public static final String START_DATE ="start_date";
  public static final String START_DAY_NUM ="start_day_num";
  public static final String START_MONTH_NUM ="start_month_num";
  public static final String END_TIME ="end_time";
  public static final String END_DATE ="end_date";
  public static final String END_DAY_NUM ="end_day_num";
  public static final String END_MONTH_NUM ="end_month_num";
  public static final String START_CRON_EXPRESSION ="start_cron_expression";
  public static final String END_CRON_EXPRESSION ="end_cron_expression";
  public static final String GENERATE_TASK ="generate_task";

}