package com.testor.module.safeCheck.model.domain;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.tongtech.tfw.backend.common.models.supers.SuperModel;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;
import lombok.experimental.Accessors;
import lombok.experimental.SuperBuilder;


/**
 * 巡检结果对象 t_safe_hazard_check_result
 * 
 * @author testor-framework
 * @date 2022-08-04 11:07:54
 */
@Data
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
@TableName("t_safe_hazard_check_result")
@ApiModel(value = "TSafeHazardCheckResult对象" , description = "")
@SuperBuilder
@AllArgsConstructor
@NoArgsConstructor
public class TSafeHazardCheckResult extends SuperModel
{
    private static final long serialVersionUID = 1L;
/**
 * id
 */
  @ApiModelProperty(value = "id")
  @TableId(value = "id",type = IdType.ASSIGN_UUID)
  private String id;

  @ApiModelProperty(value = "任务id")
  @TableField("task_id")
  private String taskId;

/**
 * 排查对象id
 */
  @ApiModelProperty(value = "排查对象id")
  @TableField("check_obj_id")
  private String checkObjId;

/**
 * 排查状态(0-带排查；1-排查中；2-完成)
 */
  @ApiModelProperty(value = "排查状态(0-带排查；1-排查中；2-完成)" , example = "0")
  @TableField("result_status")
  private Integer resultStatus;

  public static final String ID ="id";
  public static final String CHECK_OBJ_ID ="check_obj_id";
  public static final String RESULT_STATUS ="result_status";
  public static final String TASK_ID ="task_id";

}
