package com.testor.module.safeCheck.model.dto;

import com.tongtech.tfw.backend.common.models.supers.SuperModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

/**
 * 巡检对象 删除参数对象
 *
 * @author testor-framework
 * @date 2022-08-04 11:07:48
 */

@Data
public class TSafeHazardCheckObjectDTO extends SuperModel {
	/**
	 * id
	 */
	@ApiModelProperty(value = "id")
	private String id;
	/**
	 * 巡检计划id
	 */
	@ApiModelProperty(value = "巡检计划id")
	private String planId;
	/**
	 * 对象分类id
	 */
	@ApiModelProperty(value = "对象分类id")
	private String objTypeId;
	/**
	 * 排查对象
	 */
	@ApiModelProperty(value = "排查对象,多个英文,分割")
	private String objIds;
	/**
	 * 排查标准
	 */
	@ApiModelProperty(value = "排查标准")
	private String standardId;

	@ApiModelProperty(value = "类型(1-设备；2-空间；3-自定义)")
	private String type;

	@ApiModelProperty(value = "对象分类层级id")
	private String objTypeParentIds;

	@ApiModelProperty(value = "排查对象分组号(前端使用,后端不处理)")
	private String groupIndex;

	@ApiModelProperty(value = "排查对象层级id")
	private String objParentIds;

	@ApiModelProperty(value = "排查标准层级id")
	private String standardParentIds;
}
