package com.testor.module.safeCheck.service;


import com.testor.module.safeCheck.model.domain.TSafeHazardCheckObject;
import com.testor.module.safeCheck.model.domain.TSafeHazardCheckPlan;
import com.testor.module.safeCheck.model.dto.TSafeHazardCheckPlanDTO;
import com.testor.module.safeCheck.model.dto.TSafeHazardCheckPlanParam;
import com.testor.module.safeCheck.model.vo.SafeHazardCheckPlanDetailVO;
import com.testor.module.safeCheck.model.vo.TSafeHazardCheckPlanVO;
import com.tongtech.tfw.backend.common.biz.models.BaseResponse;
import com.tongtech.tfw.backend.common.biz.models.BaseResponseList;
import com.tongtech.tfw.backend.common.models.supers.SuperService;
import org.apache.ibatis.annotations.Param;

import java.util.List;

/**
 * 巡检计划Service接口
 * 
 * @author testor-framework
 * @date 2022-08-04 11:07:52
 */
public interface TSafeHazardCheckPlanService extends SuperService<TSafeHazardCheckPlan> {



    /**
     * 编辑 巡查计划
     * @param checkPlanDTO
     * @return
     */
    BaseResponse editCheckPlan(TSafeHazardCheckPlanDTO checkPlanDTO);

    BaseResponseList<TSafeHazardCheckPlanVO> listByPage(TSafeHazardCheckPlanParam param);

    /**
     * 根据id获取巡检计划
     * @return
     */
    SafeHazardCheckPlanDetailVO findById(@Param("planId") String planId);

    BaseResponse deletePlan(String planId);

    /**
     * 根据检测对象 查询 未结束的巡检计划
     * @param object : 巡检标准、对象类型-设备、对象类型-空间
     * @return
     */
    List<TSafeHazardCheckPlan> findByObjectInfo(TSafeHazardCheckObject object);
}
