package com.testor.module.sys;

/**
 * @title DictEnumCode
 * @description <TODO description class purpose>
 * @Author: qiao
 * @version:1.0.0
 * @create：7/31/23 4:48 PM
 */
import com.tongtech.tfw.backend.common.models.response.ResponseInfo;

public enum DictEnumCode {
    EXISTED(5000, "字典名称或字典编码已经存在"),
    MISS_REQUIRED(5001, "字典必填项缺失"),
    FORMAT_MISTAKE(5002, "字典值格式错误"),
    UN_DICT_TYPE(5003, "字典id不存在"),
    DICT_DATA_EXISTED(5004, "字典项已经存在"),
    DICT_DATA_EXISTED_TWO(5007, "字典项已经存在或字典值重复，请重新填写"),
    UN_DICT_DATA(5005, "字典数据ID不存在"),
    UPDATE_SUB_DICT_TYPE_ERROR(5006, "关联字典更新失败"),
    UN_DICT_TYPE_PARAM(5003, "字典参数不存在");

    private final int code;
    private final String msg;

    private DictEnumCode(int code, String msg) {
        this.code = code;
        this.msg = msg;
    }

    public int code() {
        return this.code;
    }

    public String msg() {
        return this.msg;
    }

    public ResponseInfo transform() {
        return ResponseInfo.builder().code(this.code()).msg(this.msg()).build();
    }
}
