package com.testor.module.sys.model.dto;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.testor.biz.file.model.domain.TSysFileBiz;
import io.swagger.annotations.ApiModelProperty;
import java.time.LocalDateTime;
import java.util.Date;
import java.util.List;
import javax.validation.constraints.Email;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Pattern;

import lombok.Data;
import org.hibernate.validator.constraints.Length;
import org.springframework.format.annotation.DateTimeFormat;

@Data
public class SysUserCreateAndUpdateRequest {
    @ApiModelProperty("用户表主键")
    private String userId;
    @NotNull
    @ApiModelProperty("机构表主键")
    private String orgId;
    @NotNull
    @Length(
            min = 5,
            max = 100
    )
    @ApiModelProperty("登录账号")
    private String loginName;
    @Length(
            max = 100
    )
    @ApiModelProperty("登录密码")
    private String loginPwd;
    @NotNull
    @Length(
            min = 2,
            max = 100
    )
    @ApiModelProperty("用户昵称")
    private String userName;
    @ApiModelProperty(
            value = "用户类型，在系统内部使用0表示系统管理员，1表示不是系统内部的人员",
            example = "0",
            required = true
    )
    private String userType;
    @Length(
            max = 100
    )
    @ApiModelProperty("用户头像存储路径")
    private String photoUrl;
    @ApiModelProperty("最后登陆IP")
    private String loginIp;
    @ApiModelProperty("最后登陆时间")
    @JsonFormat(timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private Date loginDate;
    @ApiModelProperty("密码安全级别，密码安全级别（ 1弱 2一般 3安全）")
    private String pwdSecurityLevel;
    @Length(
            max = 1
    )
    @ApiModelProperty("用户性别0男1女")
    private String sex;
    @Length(
            max = 255
    )
    @ApiModelProperty("联系地址")
    private String address;
    @Length(
            max = 10
    )
    @ApiModelProperty("邮政编码")
    private String zipCode;
    @Length(
            max = 30
    )
    @ApiModelProperty("电话")
    private String phoneNo;
    @ApiModelProperty("年龄")
    private int age;
    @Length(
            max = 30
    )
    @ApiModelProperty("传真")
    private String fax;
    @Email
    @Length(
            max = 50
    )
    @ApiModelProperty("邮箱")
    private String email;
    @NotNull
    @Pattern(
            regexp = "[0-2]"
    )
    @ApiModelProperty(
            value = "状态：0正常 1删除 2停用",
            example = "0",
            required = true
    )
    private String status;
    @ApiModelProperty("部门id")
    private String deptId;
    @ApiModelProperty("主岗位id")
    private String postId;
    @ApiModelProperty("副岗位id")
    private String deputyPostId;
    @Length(
            max = 255
    )
    private String remarks;
    List<TSysFileBiz> files;

    @NotBlank
    @ApiModelProperty("IAM用户id")
    private String iamUserId;

    @NotBlank
    @ApiModelProperty("人员类型")
    private String userTypeCode;

}
