package com.testor.module.threeframework.controller;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.testor.module.threeframework.model.domain.TThreeTimeAuxiliary;
import com.testor.module.threeframework.model.dto.TThreeTimeAuxiliaryDelParam;
import com.testor.module.threeframework.model.dto.TThreeTimeAuxiliaryParam;
import com.testor.module.threeframework.service.TThreeTimeAuxiliaryService;
import com.tongtech.tfw.backend.common.biz.constants.BizConstants;
import com.tongtech.tfw.backend.common.biz.models.BaseResponse;
import com.tongtech.tfw.backend.common.biz.models.BaseResponseList;
import com.tongtech.tfw.backend.common.biz.models.BizGeneralResponse;
import com.tongtech.tfw.backend.common.models.supers.SuperController;
import com.tongtech.tfw.backend.core.helper.IdHelper;
import com.tongtech.tfw.backend.core.helper.ObjectHelper;
import com.tongtech.tfw.backend.core.helper.StringHelper;
import com.tongtech.tfw.backend.core.helper.TypeHelper;
import com.tongtech.tfw.backend.core.helper.bean.BeanHelper;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.util.ArrayList;
import java.util.List;

/**
 * 三同时管理附件Controller
 *
 * @author testor-framework
 * @date 2022-09-15 17:16:21
 */
@RestController
@RequestMapping("/module/auxiliary")
@Api(value = "TThreeTimeAuxiliary", tags = "三同时管理附件")
@Slf4j
public class TThreeTimeAuxiliaryController extends SuperController {
    @Autowired
    private TThreeTimeAuxiliaryService tThreeTimeAuxiliaryService;

    /* Generated Method*/
    @ApiOperation(value = "新增 三同时管理附件", notes = "Add TThreeTimeAuxiliary")
    @PostMapping(value = "/add")
    public BaseResponse<TThreeTimeAuxiliary> addEntity(@RequestBody TThreeTimeAuxiliary addRequest) {
        BaseResponse<TThreeTimeAuxiliary> baseResponse = new BaseResponse<>();
        if (ObjectHelper.isNotEmpty(addRequest)) {
            // TODO 按需求添加数据去重，特殊值设定，业务异常
            String id = IdHelper.getId32bit();
            TThreeTimeAuxiliary data = BeanHelper.beanToBean(addRequest, TThreeTimeAuxiliary.class);
            data.setId(id);
            boolean result = tThreeTimeAuxiliaryService.save(data);
            if (result) {
                TThreeTimeAuxiliary newEntity = new TThreeTimeAuxiliary();
                newEntity.setId(id);
                baseResponse.setData(newEntity);
            }
        }
        return baseResponse;
    }

    @ApiOperation(value = "获取 三同时管理附件 ", notes = "Get TThreeTimeAuxiliary By Id")
    @GetMapping(value = "/get")
    public BaseResponse<TThreeTimeAuxiliary> getById(String id) {
        BaseResponse<TThreeTimeAuxiliary> baseResponse = new BaseResponse<>();
        if (StringHelper.isNotEmpty(id)) {
            // TODO 按需求添加业务异常判断
            TThreeTimeAuxiliary data = tThreeTimeAuxiliaryService.getById(id);
            baseResponse.setData(data);
        }
        return baseResponse;
    }

    @ApiOperation(value = "修改 三同时管理附件 ", notes = "Update TThreeTimeAuxiliary By Id")
    @PutMapping(value = "/update")
    public BaseResponse<BizGeneralResponse> updateEntity(@RequestBody TThreeTimeAuxiliary updateRequest) {
        BaseResponse<BizGeneralResponse> baseResponse = new BaseResponse<>();
        if (ObjectHelper.isNotEmpty(updateRequest) && StringHelper.isNotEmpty(updateRequest.getId())) {
            // TODO 按需求添加数据去重，特殊值设定，业务异常
            TThreeTimeAuxiliary data = BeanHelper.beanToBean(updateRequest, TThreeTimeAuxiliary.class);
            boolean result = tThreeTimeAuxiliaryService.updateById(data);
            baseResponse.setData(
                    BizGeneralResponse.builder().result(TypeHelper.castToString(result)).build());
        }
        return baseResponse;
    }

    @ApiOperation(value = "删除 三同时管理附件 ", notes = "delete TThreeTimeAuxiliary By Id")
    @PutMapping(value = "/delete")
    public BaseResponse<BizGeneralResponse> deleteEntity(@RequestBody TThreeTimeAuxiliaryDelParam deleteRequest) {
        BaseResponse<BizGeneralResponse> baseResponse = new BaseResponse<>();
        if (ObjectHelper.isNotEmpty(deleteRequest) && StringHelper.isNotEmpty(deleteRequest.getId())) {
            // TODO 按需求添加数据去重，特殊值设定，业务异常
            TThreeTimeAuxiliary data = new TThreeTimeAuxiliary();
            data.setId(deleteRequest.getId());
            data.setStatus(BizConstants.STATUS_DELETE);
            boolean result = tThreeTimeAuxiliaryService.updateById(data);
            baseResponse.setData(
                    BizGeneralResponse.builder().result(TypeHelper.castToString(result)).build());
        }
        return baseResponse;
    }

    @ApiOperation(value = "批量删除三同时管理附件", notes = "delete TThreeTimeAuxiliary by batch Id")
    @PutMapping(value = "/batch_delete")
    public BaseResponse<BizGeneralResponse> deleteEntityBatch(
            @RequestBody TThreeTimeAuxiliaryDelParam deleteRequest) {
        BaseResponse<BizGeneralResponse> baseResponse = new BaseResponse<>();
        if (ObjectHelper.isNotEmpty(deleteRequest) && (!deleteRequest.getIds().isEmpty())) {
            /* 批量删除 */
            List<TThreeTimeAuxiliary> tThreeTimeAuxiliaryList = new ArrayList<>();
            for (String id : deleteRequest.getIds()) {
                TThreeTimeAuxiliary data = new TThreeTimeAuxiliary();
                data.setId(id);
                data.setStatus(BizConstants.STATUS_DELETE);
                tThreeTimeAuxiliaryList.add(data);
            }
            boolean result = tThreeTimeAuxiliaryService.updateBatchById(tThreeTimeAuxiliaryList);
            baseResponse.setData(
                    BizGeneralResponse.builder().result(TypeHelper.castToString(result)).build());
        }
        return baseResponse;
    }

    @ApiOperation(value = "获取 三同时管理附件 分页列表", notes = "List TThreeTimeAuxiliary with page")
    @GetMapping(value = "/list")
    public BaseResponse<BaseResponseList<TThreeTimeAuxiliary>> listEntity(TThreeTimeAuxiliaryParam param) {
        BaseResponse<BaseResponseList<TThreeTimeAuxiliary>> baseResponse = new BaseResponse<>();
        Long page =
                StringHelper.isEmpty(param.getPage()) ? BizConstants.PAGE : Long.valueOf(param.getPage());
        Long limit =
                StringHelper.isEmpty(param.getLimit()) ? BizConstants.LIMIT : Long.valueOf(param.getLimit());
        Page<TThreeTimeAuxiliary> resultPage = new Page<>(page, limit);
        // TODO 根据需求修改查询条件及查询参数
        QueryWrapper<TThreeTimeAuxiliary> queryWrapper = this.createQuery(param);
        Page<TThreeTimeAuxiliary> resultList = tThreeTimeAuxiliaryService.page(resultPage, queryWrapper);
        BaseResponseList<TThreeTimeAuxiliary> baseResponseList = new BaseResponseList<>();
        baseResponseList.setData(resultList.getRecords());
        baseResponseList.setTotal(resultList.getTotal());
        baseResponse.setData(baseResponseList);
        return baseResponse;
    }

    @ApiOperation(value = "获取 三同时管理附件 列表", notes = "List TThreeTimeAuxiliary all")
    @GetMapping(value = "/datas")
    public BaseResponse<BaseResponseList<TThreeTimeAuxiliary>> listAllEntity(TThreeTimeAuxiliaryParam param) {
        BaseResponse<BaseResponseList<TThreeTimeAuxiliary>> baseResponse = new BaseResponse<>();
        // TODO 根据需求修改查询条件及查询参数
        QueryWrapper<TThreeTimeAuxiliary> queryWrapper = this.createQuery(param);
        List<TThreeTimeAuxiliary> resultList = tThreeTimeAuxiliaryService.list(queryWrapper);
        BaseResponseList<TThreeTimeAuxiliary> baseResponseList = new BaseResponseList<>();
        baseResponseList.setData(resultList);
        baseResponseList.setTotal(resultList.size());
        baseResponse.setData(baseResponseList);
        return baseResponse;
    }

    /* Private Methods */

    /**
     * 列表查询条件及查询参数
     */
    private QueryWrapper<TThreeTimeAuxiliary> createQuery(TThreeTimeAuxiliaryParam queryParam) {
        QueryWrapper<TThreeTimeAuxiliary> queryWrapper = new QueryWrapper<>();
        if (StringHelper.isNotEmpty(queryParam.getRefId())) {
            queryWrapper.eq(TThreeTimeAuxiliary.REF_ID, queryParam.getRefId());
        }
        if (StringHelper.isNotEmpty(queryParam.getParentId())) {
            queryWrapper.eq(TThreeTimeAuxiliary.PARENT_ID, queryParam.getParentId());
        }
        if (StringHelper.isNotEmpty(queryParam.getTenantId())) {
            queryWrapper.eq(TThreeTimeAuxiliary.TENANT_ID, queryParam.getTenantId());
        }
        if (StringHelper.isNotEmpty(queryParam.getProcessId())) {
            queryWrapper.eq(TThreeTimeAuxiliary.PROCESS_ID, queryParam.getProcessId());
        }
        if (StringHelper.isNotEmpty(queryParam.getProcessStatus())) {
            queryWrapper.eq(TThreeTimeAuxiliary.PROCESS_STATUS, queryParam.getProcessStatus());
        }
        if (ObjectHelper.isNotEmpty(queryParam.getReplyDate())) {
            queryWrapper.eq(TThreeTimeAuxiliary.REPLY_DATE, queryParam.getReplyDate());
        }
        if (StringHelper.isNotEmpty(queryParam.getAccessory())) {
            queryWrapper.eq(TThreeTimeAuxiliary.ACCESSORY, queryParam.getAccessory());
        }
        if (StringHelper.isNotEmpty(queryParam.getPlan())) {
            queryWrapper.eq(TThreeTimeAuxiliary.PLAN, queryParam.getPlan());
        }
        if (StringHelper.isNotEmpty(queryParam.getType())) {
            queryWrapper.eq(TThreeTimeAuxiliary.TYPE, queryParam.getType());
        }
        if (StringHelper.isNotEmpty(queryParam.getStatus())) {
            queryWrapper.eq(TThreeTimeAuxiliary.STATUS, queryParam.getStatus());
        } else {
            queryWrapper.ne(TThreeTimeAuxiliary.STATUS, BizConstants.STATUS_DELETE);
        }
        if (StringHelper.isNotEmpty(queryParam.getOrderBy())) {
            if (StringHelper.isNotEmpty(queryParam.getOrderType())
                    && BizConstants.ASC.equals(queryParam.getOrderType())) {
                queryWrapper.orderByAsc(queryParam.getOrderBy());
            } else {
                queryWrapper.orderByDesc(queryParam.getOrderBy());
            }
        } else {
            queryWrapper.orderByDesc(TThreeTimeAuxiliary.UPDATE_DATE);
        }
        return queryWrapper;
    }
}
