package com.testor.module.threeframework.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.testor.common.constant.StatusEnum;
import com.testor.module.threeframework.dao.TThreeTimeAuxiliaryDao;
import com.testor.module.threeframework.model.domain.TThreeTimeAuxiliary;
import com.testor.module.threeframework.service.TThreeTimeAuxiliaryService;
import com.tongtech.tfw.backend.common.models.supers.SuperServiceImpl;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;

/**
 * 三同时管理附件Service业务层处理
 *
 * @author testor-framework
 * @date 2022-09-15 17:16:21
 */
@Service
public class TThreeTimeAuxiliaryServiceImpl extends SuperServiceImpl<TThreeTimeAuxiliaryDao, TThreeTimeAuxiliary> implements TThreeTimeAuxiliaryService {
    @Autowired(required = false)
    private TThreeTimeAuxiliaryDao tThreeTimeAuxiliaryDao;

    @Override
    public List<TThreeTimeAuxiliary> getThreeTimeAuxiliaryByPlan(String parentId, String plan) {
        QueryWrapper<TThreeTimeAuxiliary> queryWrapper = new QueryWrapper<>();
        queryWrapper.eq("status", StatusEnum.USE.getCode());
        queryWrapper.eq("parent_id", parentId);
        queryWrapper.eq("plan", plan);
//        queryWrapper.eq("type", type);
        return list(queryWrapper);
    }

    @Override
    public TThreeTimeAuxiliary getThreeTimeAuxiliaryByPlan(String parentId, String plan, String type) {
        QueryWrapper<TThreeTimeAuxiliary> queryWrapper = new QueryWrapper<>();
        queryWrapper.eq("status", StatusEnum.USE.getCode());
        queryWrapper.eq("parent_id", parentId);
        queryWrapper.eq("plan", plan);
        queryWrapper.eq("type", type);
        return getOne(queryWrapper);
    }
}
