package com.testor.module.train.course.model.domain;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.tongtech.tfw.backend.common.models.supers.SuperModel;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;
import lombok.experimental.Accessors;
import lombok.experimental.SuperBuilder;


/**
 * 课程管理——安全培训教育对象 t_train_course
 *
 * @author testor-framework
 * @date 2022-07-25 18:06:04
 */
@Data
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
@TableName("t_train_course")
@ApiModel(value = "TTrainCourse对象", description = "")
@SuperBuilder
@AllArgsConstructor
@NoArgsConstructor
public class TTrainCourse extends SuperModel {
    private static final long serialVersionUID = 1L;
    /**
     * 主键ID
     */
    @ApiModelProperty(value = "主键ID")

    @TableId("id")
    private String id;
    /**
     * 关联ID
     */
    @ApiModelProperty(value = "关联ID")

    @TableField("ref_id")
    private String refId;
    /**
     * 父级ID
     */
    @ApiModelProperty(value = "父级ID")

    @TableField("parent_id")
    private String parentId;
    /**
     * 租户id
     */
    @ApiModelProperty(value = "租户id")

    @TableField("tenant_id")
    private String tenantId;
    /**
     * 流程实例ID
     */
    @ApiModelProperty(value = "流程实例ID")

    @TableField("process_id")
    private String processId;
    /**
     * 流程状态
     */
    @ApiModelProperty(value = "流程状态")

    @TableField("process_status")
    private String processStatus;
    /**
     * 课程名称
     */
    @ApiModelProperty(value = "课程名称")

    @TableField("course_name")
    private String courseName;
    /**
     * 课程状态
     */
    @ApiModelProperty(value = "课程状态 1开启 0 关闭")

    @TableField("course_status")
    private String courseStatus;
    /**
     * 课程详情
     */
    @ApiModelProperty(value = "课程详情")

    @TableField("course_detail")
    private String courseDetail;
    /**
     * 资料来源
     */
    @ApiModelProperty(value = "课程来源")

    @TableField("org_name")
    private String orgName;
    /**
     * 机构ID
     */
    @ApiModelProperty(value = "机构ID")

    @TableField("org_id")
    private String orgId;

    @ApiModelProperty(value = "单位层级")
    @TableField("org_level")
    private String orgLevel;

    public static final String ID = "id";
    public static final String REF_ID = "ref_id";
    public static final String PARENT_ID = "parent_id";
    public static final String TENANT_ID = "tenant_id";
    public static final String PROCESS_ID = "process_id";
    public static final String PROCESS_STATUS = "process_status";
    public static final String COURSE_NAME = "course_name";
    public static final String COURSE_STATUS = "course_status";
    public static final String COURSE_DETAIL = "course_detail";
    public static final String ORG_NAME = "org_name";
    public static final String ORG_ID = "org_id";
    public static final String ORG_LEVEL = "org_level";


}
