package com.testor.module.train.course.model.dto;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import java.util.List;
import com.testor.module.train.course.model.domain.TTrainCourse;

/**
 * 课程管理——安全培训教育 删除参数对象
 *
 * @author testor-framework
 * @date 2022-07-25 18:06:04
 */

@Data
@ApiModel(value = "TTrainCourse 列表查询参数对象")
@EqualsAndHashCode(callSuper = true)
public class TTrainCourseParam extends TTrainCourse {
	private static final long serialVersionUID = 1L;
	@ApiModelProperty(value = "每页数量")
	private String limit;

	@ApiModelProperty(value = "当前页数")
	private String page;

	@ApiModelProperty(value = "排序字段")
	private String orderBy;

	@ApiModelProperty(value = "排序方式")
	private String orderType;

	@ApiModelProperty(value = "课程进度")
	private String coursePlan;

	@ApiModelProperty(value = "任务id")
	private String taskId;

	@ApiModelProperty(value = "多个章节")
	private List<TTrainSectionParam> trainSectionParams;

}
