package com.testor.module.train.database.model.domain;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.tongtech.tfw.backend.common.models.supers.SuperModel;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;
import lombok.experimental.Accessors;
import lombok.experimental.SuperBuilder;


/**
 * 培训资料管理——安全培训教育对象 t_train_database
 *
 * @author testor-framework
 * @date 2022-07-12 10:01:27
 */
@Data
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
@TableName("t_train_database")
@ApiModel(value = "TTrainDatabase对象", description = "")
@SuperBuilder
@AllArgsConstructor
@NoArgsConstructor
public class TTrainDatabase extends SuperModel {
    private static final long serialVersionUID = 1L;
    /**
     * 主键ID
     */
    @ApiModelProperty(value = "主键ID")

    @TableId("id")
    private String id;
    /**
     * 父级ID
     */
    @ApiModelProperty(value = "父级ID")

    @TableField("parent_id")
    private String parentId;
    /**
     * 租户id
     */
    @ApiModelProperty(value = "租户id")

    @TableField("tenant_id")
    private String tenantId;
    /**
     * 流程实例ID
     */
    @ApiModelProperty(value = "流程实例ID")

    @TableField("process_id")
    private String processId;
    /**
     * 流程状态
     */
    @ApiModelProperty(value = "流程状态")

    @TableField("process_status")
    private String processStatus;
    /**
     * 资料名称
     */
    @ApiModelProperty(value = "资料名称")

    @TableField("data_name")
    private String dataName;
    /**
     * 附件id
     */
    @ApiModelProperty(value = "附件id")

    @TableField("attachment_id")
    private String attachmentId;
    /**
     * 一级科目
     */
    @ApiModelProperty(value = "一级科目")

    @TableField("stair_subject")
    private String stairSubject;
    /**
     * 二级科目
     */
    @ApiModelProperty(value = "二级科目")

    @TableField("second_subject")
    private String secondSubject;
    /**
     * 资料类型
     */
    @ApiModelProperty(value = "资料类型")

    @TableField("data_type")
    private String dataType;
    /**
     * 资料来源
     */
    @ApiModelProperty(value = "资料来源")

    @TableField("data_source")
    private String dataSource;

    /**
     * 单位层级
     */
    @ApiModelProperty(value = "资料来源层级 0 全部  1 总部  2 区域公司  3 粮库")

    @TableField("\"level\"")
    private String level;

    @TableField("org_id")
    private String orgId;

    public static final String ID = "id";
    public static final String PARENT_ID = "parent_id";
    public static final String TENANT_ID = "tenant_id";
    public static final String PROCESS_ID = "process_id";
    public static final String PROCESS_STATUS = "process_status";
    public static final String DATA_NAME = "data_name";
    public static final String ATTACHMENT_ID = "attachment_id";
    public static final String STAIR_SUBJECT = "stair_subject";
    public static final String SECOND_SUBJECT = "second_subject";
    public static final String DATA_TYPE = "data_type";
    public static final String DATA_SOURCE = "data_source";
    public static final String LEVEL = "\"level\"";


}
